/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFileLimit {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    boolean simulatedStorage = false;

    private void createFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)1, 8192L);
        byte[] buffer = new byte[1024];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void waitForLimit(FSNamesystem namesys, long num) {
        while (true) {
            long total = namesys.getBlocksTotal() + namesys.dir.totalInodes();
            System.out.println("Comparing current nodes " + total + " to become " + num);
            if (total == num) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileLimit() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int maxObjects = 5;
        conf.setLong("dfs.namenode.max.objects", maxObjects);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.heartbeat.interval", 1);
        int currentNodes = 0;
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory(conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesys = cluster.getNamesystem();
        try {
            Path file;
            Path path = new Path("/");
            Assert.assertTrue((String)"/ should be a directory", (boolean)((FileSystem)fs).getFileStatus(path).isDirectory());
            currentNodes = 1;
            for (int i = 0; i < maxObjects / 2; ++i) {
                file = new Path("/filestatus" + i);
                this.createFile(fs, file);
                System.out.println("Created file " + file);
                currentNodes += 2;
            }
            boolean hitException = false;
            try {
                file = new Path("/filestatus");
                this.createFile(fs, file);
                System.out.println("Created file " + file);
            }
            catch (IOException e) {
                hitException = true;
            }
            Assert.assertTrue((String)"Was able to exceed file limit", (boolean)hitException);
            Path file0 = new Path("/filestatus0");
            ((FileSystem)fs).delete(file0, true);
            System.out.println("Deleted file " + file0);
            this.waitForLimit(namesys, currentNodes -= 2);
            this.createFile(fs, file0);
            System.out.println("Created file " + file0 + " again.");
            currentNodes += 2;
            file0 = new Path("/filestatus0");
            ((FileSystem)fs).delete(file0, true);
            System.out.println("Deleted file " + file0 + " again.");
            this.waitForLimit(namesys, currentNodes -= 2);
            Path dir = new Path("/dir0/dir1");
            fs.mkdirs(dir);
            System.out.println("Created directories " + dir);
            this.waitForLimit(namesys, currentNodes += 2);
            hitException = false;
            try {
                fs.mkdirs(new Path("dir.fail"));
                System.out.println("Created directory should not have succeeded.");
            }
            catch (IOException e) {
                hitException = true;
            }
            Assert.assertTrue((String)"Was able to exceed dir limit", (boolean)hitException);
        }
        finally {
            ((FileSystem)fs).close();
            cluster.shutdown();
        }
    }

    @Test
    public void testFileLimitSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testFileLimit();
        this.simulatedStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMaxBlocksPerFileLimit() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        long blockSize = 4096L;
        long numBlocks = 2L;
        conf.setLong("dfs.blocksize", 4096L);
        conf.setLong("dfs.namenode.fs-limits.max-blocks-per-file", 2L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        HdfsDataOutputStream fout = (HdfsDataOutputStream)fs.create(new Path("/testmaxfilelimit"));
        try {
            fout.write(new byte[8192]);
            fout.hflush();
            try {
                fout.write(new byte[1]);
                fout.hflush();
                assert (false) : "Expected IOException after writing too many blocks";
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains("File has reached the limit on maximum number of", e);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMinBlockSizeLimit() throws Exception {
        long blockSize = 4096L;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 4096L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            fs.create(new Path("/testmblock1"), true, 4096, (short)3, 4096L);
            try {
                fs.create(new Path("/testmblock2"), true, 4096, (short)3, 4095L);
                assert (false) : "Expected IOException after creating a file with small blocks ";
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains("Specified block size is less", e);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

