/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NNThroughputBenchmark;
import org.junit.After;
import org.junit.Test;

public class TestNNThroughputBenchmark {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents(new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testNNThroughput() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        FileSystem.setDefaultUri((Configuration)conf, "hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        DFSTestUtil.formatNameNode(conf);
        String[] args = new String[]{"-op", "all"};
        NNThroughputBenchmark.runBenchmark(conf, Arrays.asList(args));
    }
}

