/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.Assert;
import org.junit.Test;

public class TestParallelImageWrite {
    private static final int NUM_DATANODES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartDFS() throws Exception {
        FileStatus dirstatus;
        FileStatus rootstatus;
        long rootmtime;
        int numNamenodeDirs;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        DFSTestUtil files = new DFSTestUtil.Builder().setName("TestRestartDFS").setNumFiles(200).build();
        String dir = "/srcdat";
        Path rootpath = new Path("/");
        Path dirpath = new Path("/srcdat");
        try {
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(4).build();
            String[] nameNodeDirs = conf.getStrings("dfs.namenode.name.dir", new String[0]);
            numNamenodeDirs = nameNodeDirs.length;
            Assert.assertTrue((String)"failed to get number of Namenode StorageDirs", (numNamenodeDirs != 0 ? 1 : 0) != 0);
            DistributedFileSystem fs = cluster.getFileSystem();
            files.createFiles(fs, "/srcdat");
            rootmtime = ((FileSystem)fs).getFileStatus(rootpath).getModificationTime();
            rootstatus = ((FileSystem)fs).getFileStatus(dirpath);
            dirstatus = ((FileSystem)fs).getFileStatus(dirpath);
            ((FileSystem)fs).setOwner(rootpath, rootstatus.getOwner() + "_XXX", null);
            ((FileSystem)fs).setOwner(dirpath, null, dirstatus.getGroup() + "_XXX");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf.setInt("dfs.namenode.checkpoint.txns", 1);
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(4).build();
            fsn = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((String)"Filesystem corrupted after restart.", (boolean)files.checkFiles(fs, "/srcdat"));
            FileStatus newrootstatus = ((FileSystem)fs).getFileStatus(rootpath);
            Assert.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            Assert.assertEquals((Object)(rootstatus.getOwner() + "_XXX"), (Object)newrootstatus.getOwner());
            Assert.assertEquals((Object)rootstatus.getGroup(), (Object)newrootstatus.getGroup());
            FileStatus newdirstatus = ((FileSystem)fs).getFileStatus(dirpath);
            Assert.assertEquals((Object)dirstatus.getOwner(), (Object)newdirstatus.getOwner());
            Assert.assertEquals((Object)(dirstatus.getGroup() + "_XXX"), (Object)newdirstatus.getGroup());
            rootmtime = ((FileSystem)fs).getFileStatus(rootpath).getModificationTime();
            String checkAfterRestart = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            files.cleanup(fs, "/srcdat");
            files.createFiles(fs, "/srcdat");
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            String checkAfterModify = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            Assert.assertFalse((String)("Modified namespace should change fsimage contents. was: " + checkAfterRestart + " now: " + checkAfterModify), (boolean)checkAfterRestart.equals(checkAfterModify));
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            files.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static String checkImages(FSNamesystem fsn, int numImageDirs) throws Exception {
        NNStorage stg = fsn.getFSImage().getStorage();
        Assert.assertEquals((String)"Some StorageDirectories failed Upgrade", (long)numImageDirs, (long)stg.getNumStorageDirs(NNStorage.NameNodeDirType.IMAGE));
        Assert.assertTrue((String)"Not enough fsimage copies in MiniDFSCluster to test parallel write", (numImageDirs > 1 ? 1 : 0) != 0);
        List<File> dirs = FSImageTestUtil.getCurrentDirs(stg, NNStorage.NameNodeDirType.IMAGE);
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, Collections.<String>emptySet());
        FSImageTestUtil.assertSameNewestImage(dirs);
        Storage.StorageDirectory firstSd = stg.dirIterator(NNStorage.NameNodeDirType.IMAGE).next();
        File latestImage = FSImageTestUtil.findLatestImageFile(firstSd);
        String md5 = FSImageTestUtil.getImageFileMD5IgnoringTxId(latestImage);
        System.err.println("md5 of " + latestImage + ": " + md5);
        return md5;
    }
}

