/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import org.apache.flink.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.junit.Assert;
import org.junit.Test;

public class TestPathComponents {
    @Test
    public void testBytes2ByteArray() throws Exception {
        this.testString("/");
        this.testString("/file");
        this.testString("/directory/");
        this.testString("//");
        this.testString("/dir//file");
        this.testString("/dir/dir1//");
    }

    public void testString(String str) throws Exception {
        String pathString = str;
        byte[][] oldPathComponents = INode.getPathComponents(pathString);
        byte[][] newPathComponents = DFSUtil.bytes2byteArray(pathString.getBytes(Charsets.UTF_8), (byte)47);
        if (oldPathComponents[0] == null) {
            Assert.assertTrue((oldPathComponents[0] == newPathComponents[0] ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Path components do not match for " + pathString), (boolean)Arrays.deepEquals((Object[])oldPathComponents, (Object[])newPathComponents));
        }
    }
}

