/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSecurityTokenEditLog {
    static final int NUM_DATA_NODES = 1;
    static final int NUM_TRANSACTIONS = 100;
    static final int NUM_THREADS = 100;
    static final int opsPerTrans = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditLog() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        try {
            int i;
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            Iterator<URI> it = cluster.getNameDirs(0).iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            editLog.setOutputBufferCapacity(2048);
            Thread[] threadId = new Thread[100];
            for (i = 0; i < 100; ++i) {
                Transactions trans = new Transactions(namesystem, 100);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            for (i = 0; i < 100; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
            editLog.close();
            namesystem.getDelegationTokenSecretManager().stopThreads();
            int numKeys = namesystem.getDelegationTokenSecretManager().getNumberOfKeys();
            int expectedTransactions = 30000 + numKeys + 2;
            for (Storage.StorageDirectory sd : fsimage.getStorage().dirIterable(NNStorage.NameNodeDirType.EDITS)) {
                File editFile = NNStorage.getFinalizedEditsFile(sd, 1L, 1 + expectedTransactions - 1);
                System.out.println("Verifying file: " + editFile);
                FSEditLogLoader loader = new FSEditLogLoader(namesystem, 0L);
                long numEdits = loader.loadFSEdits(new EditLogFileInputStream(editFile), 1L);
                Assert.assertEquals((String)("Verification for " + editFile), (long)expectedTransactions, (long)numEdits);
            }
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEditsForCancelOnTokenExpire() throws IOException, InterruptedException {
        long renewInterval = 2000L;
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setLong("dfs.namenode.delegation.token.renew-interval", renewInterval);
        conf.setLong("dfs.namenode.delegation.token.max-lifetime", renewInterval * 2L);
        Text renewer = new Text(UserGroupInformation.getCurrentUser().getUserName());
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog log = (FSEditLog)Mockito.mock(FSEditLog.class);
        ((FSImage)Mockito.doReturn((Object)log).when((Object)fsImage)).getEditLog();
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        DelegationTokenSecretManager dtsm = fsn.getDelegationTokenSecretManager();
        try {
            dtsm.startThreads();
            Token<DelegationTokenIdentifier> token1 = fsn.getDelegationToken(renewer);
            Token<DelegationTokenIdentifier> token2 = fsn.getDelegationToken(renewer);
            DelegationTokenIdentifier ident1 = token1.decodeIdentifier();
            DelegationTokenIdentifier ident2 = token2.decodeIdentifier();
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logGetDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident1), Mockito.anyLong());
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logGetDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident2), Mockito.anyLong());
            Thread.sleep(renewInterval / 2L);
            fsn.renewDelegationToken(token2);
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logRenewDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident2), Mockito.anyLong());
            dtsm.stopThreads();
            dtsm.startThreads();
            Thread.sleep(250L);
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident1));
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident2));
            Thread.sleep(renewInterval / 2L);
            dtsm.stopThreads();
            dtsm.startThreads();
            Thread.sleep(250L);
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident1));
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident2));
            Thread.sleep(renewInterval / 2L);
            dtsm.stopThreads();
            dtsm.startThreads();
            Thread.sleep(250L);
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident1));
            ((FSEditLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logCancelDelegationToken((DelegationTokenIdentifier)Mockito.eq((Object)ident2));
        }
        finally {
            dtsm.stopThreads();
        }
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting(true);
    }

    static class Transactions
    implements Runnable {
        final FSNamesystem namesystem;
        final int numTransactions;
        short replication = (short)3;
        long blockSize = 64L;

        Transactions(FSNamesystem ns, int num) {
            this.namesystem = ns;
            this.numTransactions = num;
        }

        @Override
        public void run() {
            FSEditLog editLog = this.namesystem.getEditLog();
            for (int i = 0; i < this.numTransactions; ++i) {
                try {
                    String renewer = UserGroupInformation.getLoginUser().getUserName();
                    Token<DelegationTokenIdentifier> token = this.namesystem.getDelegationToken(new Text(renewer));
                    this.namesystem.renewDelegationToken(token);
                    this.namesystem.cancelDelegationToken(token);
                    editLog.logSync();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Transaction " + i + " encountered exception " + e);
                }
            }
        }
    }
}

