/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestHAWebUI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkAndClusterSummary() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            String pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress(cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertTrue((boolean)pageContents.contains("Browse the filesystem"));
            Assert.assertTrue((boolean)pageContents.contains("Number of Under-Replicated Blocks"));
            cluster.transitionToStandby(0);
            pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress(cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertFalse((boolean)pageContents.contains("Browse the filesystem"));
            Assert.assertFalse((boolean)pageContents.contains("Number of Under-Replicated Blocks"));
            cluster.transitionToActive(0);
            pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + NameNode.getHttpAddress(cluster.getConfiguration(0)).getPort() + "/dfshealth.jsp"));
            Assert.assertTrue((boolean)pageContents.contains("Browse the filesystem"));
            Assert.assertTrue((boolean)pageContents.contains("Number of Under-Replicated Blocks"));
        }
        finally {
            cluster.shutdown();
        }
    }
}

