/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSnapshotRename {
    static final long seed = 0L;
    static final short REPLICATION = 3;
    static final long BLOCKSIZE = 1024L;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    FSDirectory fsdir;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.fsdir = this.fsn.getFSDirectory();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void checkSnapshotList(INodeDirectorySnapshottable srcRoot, String[] sortedNames, String[] names) {
        ReadOnlyList<Snapshot> listByName = srcRoot.getSnapshotsByNames();
        Assert.assertEquals((long)sortedNames.length, (long)listByName.size());
        for (int i = 0; i < listByName.size(); ++i) {
            Assert.assertEquals((Object)sortedNames[i], (Object)listByName.get(i).getRoot().getLocalName());
        }
        List listByTime = srcRoot.getDiffs().asList();
        Assert.assertEquals((long)names.length, (long)listByTime.size());
        for (int i = 0; i < listByTime.size(); ++i) {
            Snapshot s = srcRoot.getSnapshotById(((DirectoryWithSnapshotFeature.DirectoryDiff)listByTime.get(i)).getSnapshotId());
            Assert.assertEquals((Object)names[i], (Object)s.getRoot().getLocalName());
        }
    }

    @Test(timeout=60000L)
    public void testSnapshotList() throws Exception {
        DFSTestUtil.createFile(this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s2");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s3");
        this.hdfs.renameSnapshot(this.sub1, "s3", "s22");
        INodeDirectorySnapshottable srcRoot = INodeDirectorySnapshottable.valueOf(this.fsdir.getINode(this.sub1.toString()), this.sub1.toString());
        this.checkSnapshotList(srcRoot, new String[]{"s1", "s2", "s22"}, new String[]{"s1", "s2", "s22"});
        this.hdfs.renameSnapshot(this.sub1, "s1", "s4");
        this.checkSnapshotList(srcRoot, new String[]{"s2", "s22", "s4"}, new String[]{"s4", "s2", "s22"});
        this.hdfs.renameSnapshot(this.sub1, "s22", "s0");
        this.checkSnapshotList(srcRoot, new String[]{"s0", "s2", "s4"}, new String[]{"s4", "s2", "s0"});
    }

    @Test(timeout=60000L)
    public void testSnapshotRename() throws Exception {
        DFSTestUtil.createFile(this.hdfs, this.file1, 1024L, (short)3, 0L);
        Path snapshotRoot = SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        Path ssPath = new Path(snapshotRoot, this.file1.getName());
        Assert.assertTrue((boolean)this.hdfs.exists(ssPath));
        FileStatus statusBeforeRename = this.hdfs.getFileStatus(ssPath);
        this.hdfs.renameSnapshot(this.sub1, "s1", "s2");
        Assert.assertFalse((boolean)this.hdfs.exists(ssPath));
        snapshotRoot = SnapshotTestHelper.getSnapshotRoot(this.sub1, "s2");
        ssPath = new Path(snapshotRoot, this.file1.getName());
        Assert.assertTrue((boolean)this.hdfs.exists(ssPath));
        FileStatus statusAfterRename = this.hdfs.getFileStatus(ssPath);
        Assert.assertFalse((boolean)statusBeforeRename.equals(statusAfterRename));
        statusBeforeRename.setPath(statusAfterRename.getPath());
        Assert.assertEquals((Object)statusBeforeRename.toString(), (Object)statusAfterRename.toString());
    }

    @Test(timeout=60000L)
    public void testRenameNonExistingSnapshot() throws Exception {
        DFSTestUtil.createFile(this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        this.exception.expect(SnapshotException.class);
        String error = "The snapshot wrongName does not exist for directory " + this.sub1.toString();
        this.exception.expectMessage(error);
        this.hdfs.renameSnapshot(this.sub1, "wrongName", "s2");
    }

    @Test(timeout=60000L)
    public void testRenameToExistingSnapshot() throws Exception {
        DFSTestUtil.createFile(this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s2");
        this.exception.expect(SnapshotException.class);
        String error = "The snapshot s2 already exists for directory " + this.sub1.toString();
        this.exception.expectMessage(error);
        this.hdfs.renameSnapshot(this.sub1, "s1", "s2");
    }

    @Test
    public void testRenameWithIllegalName() throws Exception {
        String[] badNames;
        DFSTestUtil.createFile(this.hdfs, this.file1, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s1");
        String name1 = ".snapshot";
        try {
            this.hdfs.renameSnapshot(this.sub1, "s1", ".snapshot");
            Assert.fail((String)"Exception expected when an illegal name is given for rename");
        }
        catch (RemoteException e) {
            String errorMsg = "\".snapshot\" is a reserved name.";
            GenericTestUtils.assertExceptionContains(errorMsg, e);
        }
        String errorMsg = "Snapshot name cannot contain \"/\"";
        for (String badName : badNames = new String[]{"foo/", "/foo", "/", "foo/bar"}) {
            try {
                this.hdfs.renameSnapshot(this.sub1, "s1", badName);
                Assert.fail((String)"Exception expected when an illegal name is given");
            }
            catch (RemoteException e) {
                GenericTestUtils.assertExceptionContains(errorMsg, e);
            }
        }
    }

    @Test
    public void testRenameSnapshotCommandWithIllegalArguments() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        System.setErr(psOut);
        FsShell shell = new FsShell();
        shell.setConf(this.conf);
        String[] argv1 = new String[]{"-renameSnapshot", "/tmp", "s1"};
        int val = shell.run(argv1);
        Assert.assertTrue((val == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)out.toString().contains(argv1[0] + ": Incorrect number of arguments."));
        out.reset();
        String[] argv2 = new String[]{"-renameSnapshot", "/tmp", "s1", "s2", "s3"};
        val = shell.run(argv2);
        Assert.assertTrue((val == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)out.toString().contains(argv2[0] + ": Incorrect number of arguments."));
        psOut.close();
        out.close();
    }
}

