/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.SpotCheckImageVisitor;
import org.junit.Assert;
import org.junit.Test;

public class TestOIVCanReadOldVersions {
    public static final String TEST_CACHE_DATA_DIR = System.getProperty("test.cache.data", "build/test/cache");

    @Test
    public void testOldFSImages() {
        HashSet<String> pathNames = new HashSet<String>();
        Collections.addAll(pathNames, "", "/bar", "/bar/dir0", "/bar/dir0/file0", "/bar/dir0/file1", "/bar/dir1", "/bar/dir1/file0", "/bar/dir1/file1", "/bar/dir2", "/bar/dir2/file0", "/bar/dir2/file1", "/foo", "/foo/dir0", "/foo/dir0/file0", "/foo/dir0/file1", "/foo/dir0/file2", "/foo/dir0/file3", "/foo/dir1", "/foo/dir1/file0", "/foo/dir1/file1", "/foo/dir1/file2", "/foo/dir1/file3");
        HashSet<String> INUCpaths = new HashSet<String>();
        Collections.addAll(INUCpaths, "/bar/dir0/file0", "/bar/dir0/file1", "/bar/dir1/file0", "/bar/dir1/file1", "/bar/dir2/file0", "/bar/dir2/file1");
        SpotCheckImageVisitor.ImageInfo v18Inodes = new SpotCheckImageVisitor.ImageInfo();
        v18Inodes.totalNumBlocks = 12L;
        v18Inodes.totalFileSize = 1069548540L;
        v18Inodes.pathNames = pathNames;
        v18Inodes.totalReplications = 14L;
        SpotCheckImageVisitor.ImageInfo v18INUCs = new SpotCheckImageVisitor.ImageInfo();
        v18INUCs.totalNumBlocks = 0L;
        v18INUCs.totalFileSize = 0L;
        v18INUCs.pathNames = INUCpaths;
        v18INUCs.totalReplications = 6L;
        SpotCheckImageVisitor.ImageInfo v19Inodes = new SpotCheckImageVisitor.ImageInfo();
        v19Inodes.totalNumBlocks = 12L;
        v19Inodes.totalFileSize = 1069548540L;
        v19Inodes.pathNames = pathNames;
        v19Inodes.totalReplications = 14L;
        SpotCheckImageVisitor.ImageInfo v19INUCs = new SpotCheckImageVisitor.ImageInfo();
        v19INUCs.totalNumBlocks = 0L;
        v19INUCs.totalFileSize = 0L;
        v19INUCs.pathNames = INUCpaths;
        v19INUCs.totalReplications = 6L;
        this.spotCheck("18", TEST_CACHE_DATA_DIR + "/fsimageV18", v18Inodes, v18INUCs);
        this.spotCheck("19", TEST_CACHE_DATA_DIR + "/fsimageV19", v19Inodes, v19INUCs);
    }

    private void spotCheck(String hadoopVersion, String input, SpotCheckImageVisitor.ImageInfo inodes, SpotCheckImageVisitor.ImageInfo INUCs) {
        SpotCheckImageVisitor v = new SpotCheckImageVisitor();
        OfflineImageViewer oiv = new OfflineImageViewer(input, v, false);
        try {
            oiv.go();
        }
        catch (IOException e) {
            Assert.fail((String)("Error processing file: " + input));
        }
        this.compareSpotCheck(hadoopVersion, v.getINodesInfo(), inodes);
        this.compareSpotCheck(hadoopVersion, v.getINUCsInfo(), INUCs);
        System.out.println("Successfully processed fsimage file from Hadoop version " + hadoopVersion);
    }

    private void compareSpotCheck(String hadoopVersion, SpotCheckImageVisitor.ImageInfo generated, SpotCheckImageVisitor.ImageInfo expected) {
        Assert.assertEquals((String)("Version " + hadoopVersion + ": Same number of total blocks"), (long)expected.totalNumBlocks, (long)generated.totalNumBlocks);
        Assert.assertEquals((String)("Version " + hadoopVersion + ": Same total file size"), (long)expected.totalFileSize, (long)generated.totalFileSize);
        Assert.assertEquals((String)("Version " + hadoopVersion + ": Same total replication factor"), (long)expected.totalReplications, (long)generated.totalReplications);
        Assert.assertEquals((String)("Version " + hadoopVersion + ": One-to-one matching of path names"), expected.pathNames, generated.pathNames);
    }
}

