/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAtomicFileOutputStream {
    private static final String TEST_STRING = "hello world";
    private static final String TEST_STRING_2 = "goodbye world";
    private static final File TEST_DIR = PathUtils.getTestDir(TestAtomicFileOutputStream.class);
    private static final File DST_FILE = new File(TEST_DIR, "test.txt");

    @Before
    public void cleanupTestDir() throws IOException {
        Assert.assertTrue((TEST_DIR.exists() || TEST_DIR.mkdirs() ? 1 : 0) != 0);
        FileUtil.fullyDeleteContents(TEST_DIR);
    }

    @Test
    public void testWriteNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(DST_FILE);
        Assert.assertFalse((boolean)DST_FILE.exists());
        ((OutputStream)fos).write(TEST_STRING.getBytes());
        ((OutputStream)fos).flush();
        Assert.assertFalse((boolean)DST_FILE.exists());
        ((OutputStream)fos).close();
        Assert.assertTrue((boolean)DST_FILE.exists());
        String readBackData = DFSTestUtil.readFile(DST_FILE);
        Assert.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testOverwriteFile() throws IOException {
        Assert.assertTrue((String)"Creating empty dst file", (boolean)DST_FILE.createNewFile());
        AtomicFileOutputStream fos = new AtomicFileOutputStream(DST_FILE);
        Assert.assertTrue((String)"Empty file still exists", (boolean)DST_FILE.exists());
        ((OutputStream)fos).write(TEST_STRING.getBytes());
        ((OutputStream)fos).flush();
        Assert.assertEquals((Object)"", (Object)DFSTestUtil.readFile(DST_FILE));
        ((OutputStream)fos).close();
        String readBackData = DFSTestUtil.readFile(DST_FILE);
        Assert.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testFailToFlush() throws IOException {
        FileOutputStream fos = new FileOutputStream(DST_FILE);
        fos.write(TEST_STRING_2.getBytes());
        fos.close();
        OutputStream failingStream = this.createFailingStream();
        failingStream.write(TEST_STRING.getBytes());
        try {
            failingStream.close();
            Assert.fail((String)"Close didn't throw exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)TEST_STRING_2, (Object)DFSTestUtil.readFile(DST_FILE));
        Assert.assertEquals((String)"Temporary file should have been cleaned up", (Object)DST_FILE.getName(), (Object)Joiner.on(",").join(TEST_DIR.list()));
    }

    private OutputStream createFailingStream() throws FileNotFoundException {
        return new AtomicFileOutputStream(DST_FILE){

            @Override
            public void flush() throws IOException {
                throw new IOException("injected failure");
            }
        };
    }
}

