/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpServer2;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHtmlQuoting {
    @Test
    public void testNeedsQuoting() throws Exception {
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting("abcde>"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting("<abcde"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting("abc'de"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting("abcde\""));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting("&"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting(""));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting("ab\ncdef"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting(null));
    }

    @Test
    public void testQuoting() throws Exception {
        Assert.assertEquals((Object)"ab&lt;cd", (Object)HtmlQuoting.quoteHtmlChars("ab<cd"));
        Assert.assertEquals((Object)"ab&gt;", (Object)HtmlQuoting.quoteHtmlChars("ab>"));
        Assert.assertEquals((Object)"&amp;&amp;&amp;", (Object)HtmlQuoting.quoteHtmlChars("&&&"));
        Assert.assertEquals((Object)" &apos;\n", (Object)HtmlQuoting.quoteHtmlChars(" '\n"));
        Assert.assertEquals((Object)"&quot;", (Object)HtmlQuoting.quoteHtmlChars("\""));
        Assert.assertEquals(null, (Object)HtmlQuoting.quoteHtmlChars(null));
    }

    private void runRoundTrip(String str) throws Exception {
        Assert.assertEquals((Object)str, (Object)HtmlQuoting.unquoteHtmlChars(HtmlQuoting.quoteHtmlChars(str)));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.runRoundTrip("");
        this.runRoundTrip("<>&'\"");
        this.runRoundTrip("ab>cd<ef&ghi'\"");
        this.runRoundTrip("A string\n with no quotable chars in it!");
        this.runRoundTrip(null);
        StringBuilder buffer = new StringBuilder();
        for (char ch = '\u0000'; ch < '\u007f'; ch = (char)(ch + '\u0001')) {
            buffer.append(ch);
        }
        this.runRoundTrip(buffer.toString());
    }

    @Test
    public void testRequestQuoting() throws Exception {
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServer2.QuotingInputFilter.RequestQuoter quoter = new HttpServer2.QuotingInputFilter.RequestQuoter(mockReq);
        ((HttpServletRequest)Mockito.doReturn((Object)"a<b").when((Object)mockReq)).getParameter("x");
        Assert.assertEquals((String)"Test simple param quoting", (Object)"a&lt;b", (Object)quoter.getParameter("x"));
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameter("x");
        Assert.assertEquals((String)"Test that missing parameters dont cause NPE", null, (Object)quoter.getParameter("x"));
        ((HttpServletRequest)Mockito.doReturn((Object)new String[]{"a<b", "b"}).when((Object)mockReq)).getParameterValues("x");
        Assert.assertArrayEquals((String)"Test escaping of an array", (Object[])new String[]{"a&lt;b", "b"}, (Object[])quoter.getParameterValues("x"));
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameterValues("x");
        Assert.assertArrayEquals((String)"Test that missing parameters dont cause NPE for array", null, (Object[])quoter.getParameterValues("x"));
    }
}

