/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.mortbay.jetty.servlet.Context;

public class TestServletFilter
extends HttpServerFunctionalTest {
    static final Log LOG = LogFactory.getLog(HttpServer2.class);
    static volatile String uri = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(String urlstring) throws IOException {
        LOG.warn((Object)("access " + urlstring));
        URL url = new URL(urlstring);
        URLConnection connection = url.openConnection();
        connection.connect();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                while (in.readLine() != null) {
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("urlstring=" + urlstring), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletFilter() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", SimpleFilter.Initializer.class.getName());
        HttpServer2 http = TestServletFilter.createTestServer(conf);
        http.start();
        String fsckURL = "/fsck";
        String stacksURL = "/stacks";
        String ajspURL = "/a.jsp";
        String logURL = "/logs/a.log";
        String hadooplogoURL = "/static/hadoop-logo.jpg";
        String[] urls = new String[]{"/fsck", "/stacks", "/a.jsp", "/logs/a.log", "/static/hadoop-logo.jpg"};
        Random ran = new Random();
        int[] sequence = new int[50];
        for (int i = 0; i < sequence.length; ++i) {
            sequence[i] = ran.nextInt(urls.length);
        }
        String prefix = "http://" + NetUtils.getHostPortString(http.getConnectorAddress(0));
        try {
            for (int i = 0; i < sequence.length; ++i) {
                TestServletFilter.access(prefix + urls[sequence[i]]);
                if (sequence[i] == 0) {
                    TestServletFilter.assertEquals(null, (Object)uri);
                    continue;
                }
                TestServletFilter.assertEquals((Object)urls[sequence[i]], (Object)uri);
                uri = null;
            }
        }
        finally {
            http.stop();
        }
    }

    @Test
    public void testServletFilterWhenInitThrowsException() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", ErrorFilter.Initializer.class.getName());
        HttpServer2 http = TestServletFilter.createTestServer(conf);
        try {
            http.start();
            TestServletFilter.fail((String)"expecting exception");
        }
        catch (IOException e) {
            TestServletFilter.assertTrue((boolean)e.getMessage().contains("Problem in starting http server. Server handlers failed"));
        }
    }

    @Test
    public void testContextSpecificServletFilterWhenInitThrowsException() throws Exception {
        Configuration conf = new Configuration();
        HttpServer2 http = TestServletFilter.createTestServer(conf);
        HttpServer2.defineFilter((Context)http.webAppContext, "ErrorFilter", ErrorFilter.class.getName(), null, null);
        try {
            http.start();
            TestServletFilter.fail((String)"expecting exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Unable to initialize WebAppContext", e);
        }
    }

    public static class ErrorFilter
    extends SimpleFilter {
        @Override
        public void init(FilterConfig arg0) throws ServletException {
            throw new ServletException("Throwing the exception from Filter init");
        }

        public static class Initializer
        extends FilterInitializer {
            @Override
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("simple", ErrorFilter.class.getName(), null);
            }
        }
    }

    public static class SimpleFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) throws ServletException {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info((Object)("filtering " + uri));
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            @Override
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("simple", SimpleFilter.class.getName(), null);
            }
        }
    }
}

