/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class RandomDatum
implements WritableComparable<RandomDatum> {
    private int length;
    private byte[] data;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public RandomDatum() {
    }

    public RandomDatum(Random random) {
        this.length = 10 + (int)Math.pow(10.0, (double)random.nextFloat() * 3.0);
        this.data = new byte[this.length];
        random.nextBytes(this.data);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.data);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        if (this.data == null || this.length > this.data.length) {
            this.data = new byte[this.length];
        }
        in.readFully(this.data, 0, this.length);
    }

    @Override
    public int compareTo(RandomDatum o) {
        return WritableComparator.compareBytes(this.data, 0, this.length, o.data, 0, o.length);
    }

    public boolean equals(Object o) {
        return this.compareTo((RandomDatum)o) == 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.length * 2);
        for (int i = 0; i < this.length; ++i) {
            byte b = this.data[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(RandomDatum.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = Comparator.readInt(b1, s1);
            int n2 = Comparator.readInt(b2, s2);
            return Comparator.compareBytes(b1, s1 + 4, n1, b2, s2 + 4, n2);
        }
    }

    public static class Generator {
        Random random;
        private RandomDatum key;
        private RandomDatum value;

        public Generator() {
            this.random = new Random();
        }

        public Generator(int seed) {
            this.random = new Random(seed);
        }

        public RandomDatum getKey() {
            return this.key;
        }

        public RandomDatum getValue() {
            return this.value;
        }

        public void next() {
            this.key = new RandomDatum(this.random);
            this.value = new RandomDatum(this.random);
        }
    }
}

