/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DataOutputByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestDataByteBuffers {
    private static void readJunk(DataInput in, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block9: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(7)) {
                case 0: {
                    Assert.assertEquals((long)((byte)(r.nextInt() & 0xFF)), (long)in.readByte());
                    continue block9;
                }
                case 1: {
                    Assert.assertEquals((long)((short)(r.nextInt() & 0xFFFF)), (long)in.readShort());
                    continue block9;
                }
                case 2: {
                    Assert.assertEquals((long)r.nextInt(), (long)in.readInt());
                    continue block9;
                }
                case 3: {
                    Assert.assertEquals((long)r.nextLong(), (long)in.readLong());
                    continue block9;
                }
                case 4: {
                    Assert.assertEquals((long)Double.doubleToLongBits(r.nextDouble()), (long)Double.doubleToLongBits(in.readDouble()));
                    continue block9;
                }
                case 5: {
                    Assert.assertEquals((long)Float.floatToIntBits(r.nextFloat()), (long)Float.floatToIntBits(in.readFloat()));
                    continue block9;
                }
                case 6: {
                    int len = r.nextInt(1024);
                    byte[] vb = new byte[len];
                    r.nextBytes(vb);
                    byte[] b = new byte[len];
                    in.readFully(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                }
            }
        }
    }

    private static void writeJunk(DataOutput out, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block9: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(7)) {
                case 0: {
                    out.writeByte(r.nextInt());
                    continue block9;
                }
                case 1: {
                    out.writeShort((short)(r.nextInt() & 0xFFFF));
                    continue block9;
                }
                case 2: {
                    out.writeInt(r.nextInt());
                    continue block9;
                }
                case 3: {
                    out.writeLong(r.nextLong());
                    continue block9;
                }
                case 4: {
                    out.writeDouble(r.nextDouble());
                    continue block9;
                }
                case 5: {
                    out.writeFloat(r.nextFloat());
                    continue block9;
                }
                case 6: {
                    byte[] b = new byte[r.nextInt(1024)];
                    r.nextBytes(b);
                    out.write(b);
                }
            }
        }
    }

    @Test
    public void testBaseBuffers() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("SEED: " + seed);
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
        dob.reset();
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        dib.reset(dob.getData(), 0, dob.getLength());
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
    }

    @Test
    public void testByteBuffers() throws IOException {
        DataOutputByteBuffer dob = new DataOutputByteBuffer();
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("SEED: " + seed);
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        DataInputByteBuffer dib = new DataInputByteBuffer();
        dib.reset(dob.getData());
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
        dob.reset();
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        dib.reset(dob.getData());
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
    }

    private static byte[] toBytes(ByteBuffer[] bufs, int len) {
        byte[] ret = new byte[len];
        int pos = 0;
        for (int i = 0; i < bufs.length; ++i) {
            int rem = bufs[i].remaining();
            bufs[i].get(ret, pos, rem);
            pos += rem;
        }
        return ret;
    }

    @Test
    public void testDataOutputByteBufferCompatibility() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        DataOutputByteBuffer dobb = new DataOutputByteBuffer();
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("SEED: " + seed);
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        TestDataByteBuffers.writeJunk(dobb, r, seed, 1000);
        byte[] check = TestDataByteBuffers.toBytes(dobb.getData(), dobb.getLength());
        Assert.assertEquals((long)dob.getLength(), (long)check.length);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(dob.getData(), dob.getLength()), (byte[])check);
        dob.reset();
        dobb.reset();
        TestDataByteBuffers.writeJunk(dob, r, seed, 3000);
        TestDataByteBuffers.writeJunk(dobb, r, seed, 3000);
        check = TestDataByteBuffers.toBytes(dobb.getData(), dobb.getLength());
        Assert.assertEquals((long)dob.getLength(), (long)check.length);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(dob.getData(), dob.getLength()), (byte[])check);
        dob.reset();
        dobb.reset();
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        TestDataByteBuffers.writeJunk(dobb, r, seed, 1000);
        check = TestDataByteBuffers.toBytes(dobb.getData(), dobb.getLength());
        Assert.assertEquals((long)dob.getLength(), (long)check.length);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(dob.getData(), dob.getLength()), (byte[])check);
    }

    @Test
    public void TestDataInputByteBufferCompatibility() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("SEED: " + seed);
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        ByteBuffer buf = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        DataInputByteBuffer dib = new DataInputByteBuffer();
        dib.reset(buf);
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
    }

    @Test
    public void TestDataOutputByteBufferCompatibility() throws IOException {
        DataOutputByteBuffer dob = new DataOutputByteBuffer();
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("SEED: " + seed);
        TestDataByteBuffers.writeJunk(dob, r, seed, 1000);
        ByteBuffer buf = ByteBuffer.allocate(dob.getLength());
        for (ByteBuffer b : dob.getData()) {
            buf.put(b);
        }
        buf.flip();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(buf.array(), 0, buf.remaining());
        TestDataByteBuffers.readJunk(dib, r, seed, 1000);
    }
}

