/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestMapWritable
extends TestCase {
    public void testMapWritable() {
        Text[] keys = new Text[]{new Text("key1"), new Text("key2"), new Text("Key3")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes()), new BytesWritable("value3".getBytes())};
        MapWritable inMap = new MapWritable();
        for (int i = 0; i < keys.length; ++i) {
            inMap.put(keys[i], values[i]);
        }
        MapWritable outMap = new MapWritable(inMap);
        TestMapWritable.assertEquals((int)inMap.size(), (int)outMap.size());
        for (Map.Entry<Writable, Writable> e : inMap.entrySet()) {
            TestMapWritable.assertTrue((boolean)outMap.containsKey(e.getKey()));
            TestMapWritable.assertEquals((int)0, (int)((WritableComparable)outMap.get(e.getKey())).compareTo(e.getValue()));
        }
        Text[] maps = new Text[]{new Text("map1"), new Text("map2")};
        MapWritable mapOfMaps = new MapWritable();
        mapOfMaps.put(maps[0], inMap);
        mapOfMaps.put(maps[1], outMap);
        MapWritable copyOfMapOfMaps = new MapWritable(mapOfMaps);
        for (int i = 0; i < maps.length; ++i) {
            TestMapWritable.assertTrue((boolean)copyOfMapOfMaps.containsKey(maps[i]));
            MapWritable a = (MapWritable)mapOfMaps.get(maps[i]);
            MapWritable b = (MapWritable)copyOfMapOfMaps.get(maps[i]);
            TestMapWritable.assertEquals((int)a.size(), (int)b.size());
            for (Writable key : a.keySet()) {
                TestMapWritable.assertTrue((boolean)b.containsKey(key));
                WritableComparable aValue = (WritableComparable)a.get(key);
                WritableComparable bValue = (WritableComparable)b.get(key);
                TestMapWritable.assertEquals((int)0, (int)aValue.compareTo(bValue));
            }
        }
    }

    public void testForeignClass() {
        MapWritable inMap = new MapWritable();
        inMap.put(new Text("key"), new UTF8("value"));
        inMap.put(new Text("key2"), new UTF8("value2"));
        MapWritable outMap = new MapWritable(inMap);
        MapWritable copyOfCopy = new MapWritable(outMap);
        TestMapWritable.assertEquals((int)1, (int)copyOfCopy.getNewClasses());
    }

    public void testMultipleCallsToReadFieldsAreSafe() throws Exception {
        MapWritable m = new MapWritable();
        Text t = new Text(this.getName());
        m.put(t, t);
        int count = m.size();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        m.write(dos);
        dos.close();
        m.put(new Text("key1"), new Text("value1"));
        m.put(new Text("key2"), new Text("value2"));
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        m.readFields(dis);
        TestMapWritable.assertEquals((int)count, (int)m.size());
        TestMapWritable.assertTrue((boolean)m.get(t).equals(t));
        dis.close();
    }

    public void testEquality() {
        MapWritable map1 = new MapWritable();
        MapWritable map2 = new MapWritable();
        MapWritable map3 = new MapWritable();
        IntWritable k1 = new IntWritable(5);
        IntWritable k2 = new IntWritable(10);
        Text value = new Text("value");
        map1.put(k1, value);
        map2.put(k1, value);
        map3.put(k2, value);
        TestMapWritable.assertTrue((boolean)map1.equals(map2));
        TestMapWritable.assertTrue((boolean)map2.equals(map1));
        TestMapWritable.assertFalse((boolean)map1.equals(map3));
        TestMapWritable.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        TestMapWritable.assertFalse((map1.hashCode() == map3.hashCode() ? 1 : 0) != 0);
    }
}

