/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.ReflectionUtils;

public class TestWritable
extends TestCase {
    public TestWritable(String name) {
        super(name);
    }

    public void testSimpleWritable() throws Exception {
        TestWritable.testWritable(new SimpleWritable());
    }

    public void testByteWritable() throws Exception {
        TestWritable.testWritable(new ByteWritable(-128));
    }

    public void testShortWritable() throws Exception {
        TestWritable.testWritable(new ShortWritable(0));
    }

    public void testDoubleWritable() throws Exception {
        TestWritable.testWritable(new DoubleWritable(1.0));
    }

    public static Writable testWritable(Writable before) throws Exception {
        return TestWritable.testWritable(before, null);
    }

    public static Writable testWritable(Writable before, Configuration conf) throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        before.write(dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), dob.getLength());
        Writable after = (Writable)ReflectionUtils.newInstance(before.getClass(), conf);
        after.readFields(dib);
        TestWritable.assertEquals((Object)before, (Object)after);
        return after;
    }

    public static void testGetComparator() throws Exception {
        assert (WritableComparator.get(Frob.class) instanceof FrobComparator);
    }

    public void testShortWritableComparator() throws Exception {
        ShortWritable writable1 = new ShortWritable(256);
        ShortWritable writable2 = new ShortWritable(128);
        ShortWritable writable3 = new ShortWritable(256);
        String SHOULD_NOT_MATCH_WITH_RESULT_ONE = "Result should be 1, should not match the writables";
        TestWritable.assertTrue((String)"Result should be 1, should not match the writables", (writable1.compareTo(writable2) == 1 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be 1, should not match the writables", (WritableComparator.get(ShortWritable.class).compare(writable1, writable2) == 1 ? 1 : 0) != 0);
        String SHOULD_NOT_MATCH_WITH_RESULT_MINUS_ONE = "Result should be -1, should not match the writables";
        TestWritable.assertTrue((String)"Result should be -1, should not match the writables", (writable2.compareTo(writable1) == -1 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be -1, should not match the writables", (WritableComparator.get(ShortWritable.class).compare(writable2, writable1) == -1 ? 1 : 0) != 0);
        String SHOULD_MATCH = "Result should be 0, should match the writables";
        TestWritable.assertTrue((String)"Result should be 0, should match the writables", (writable1.compareTo(writable1) == 0 ? 1 : 0) != 0);
        TestWritable.assertTrue((String)"Result should be 0, should match the writables", (WritableComparator.get(ShortWritable.class).compare(writable1, writable3) == 0 ? 1 : 0) != 0);
    }

    private static class Frob
    implements WritableComparable<Frob> {
        private Frob() {
        }

        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public int compareTo(Frob o) {
            return 0;
        }

        static {
            WritableComparator.define(Frob.class, new FrobComparator());
        }
    }

    private static class FrobComparator
    extends WritableComparator {
        public FrobComparator() {
            super(Frob.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return 0;
        }
    }

    public static class SimpleWritable
    implements Writable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.state);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.state = in.readInt();
        }

        public static SimpleWritable read(DataInput in) throws IOException {
            SimpleWritable result = new SimpleWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleWritable)) {
                return false;
            }
            SimpleWritable other = (SimpleWritable)o;
            return this.state == other.state;
        }
    }
}

