/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.IFileOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFile {
    private static final Log LOG = LogFactory.getLog(IFile.class);
    public static final int EOF_MARKER = -1;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Reader<K, V> {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private static final int MAX_VINT_SIZE = 9;
        private long numRecordsRead = 0L;
        private final Counters.Counter readRecordsCounter;
        final InputStream in;
        Decompressor decompressor;
        public long bytesRead = 0L;
        protected final long fileLength;
        protected boolean eof = false;
        final IFileInputStream checksumIn;
        protected byte[] buffer = null;
        protected int bufferSize = 131072;
        protected DataInputStream dataIn;
        protected int recNo = 1;
        protected int currentKeyLength;
        protected int currentValueLength;
        byte[] keyBytes = new byte[0];

        public Reader(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, Counters.Counter readsCounter) throws IOException {
            this(conf, fs.open(file), fs.getFileStatus(file).getLen(), codec, readsCounter);
        }

        public Reader(Configuration conf, FSDataInputStream in, long length, CompressionCodec codec, Counters.Counter readsCounter) throws IOException {
            this.readRecordsCounter = readsCounter;
            this.checksumIn = new IFileInputStream(in, length, conf);
            if (codec != null) {
                this.decompressor = CodecPool.getDecompressor(codec);
                if (this.decompressor != null) {
                    this.in = codec.createInputStream(this.checksumIn, this.decompressor);
                } else {
                    LOG.warn((Object)"Could not obtain decompressor from CodecPool");
                    this.in = this.checksumIn;
                }
            } else {
                this.in = this.checksumIn;
            }
            this.dataIn = new DataInputStream(this.in);
            this.fileLength = length;
            if (conf != null) {
                this.bufferSize = conf.getInt("io.file.buffer.size", 131072);
            }
        }

        public long getLength() {
            return this.fileLength - this.checksumIn.getSize();
        }

        public long getPosition() throws IOException {
            return this.checksumIn.getPosition();
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = IOUtils.wrappedReadForCompressedData(this.in, buf, off + bytesRead, len - bytesRead);
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        protected boolean positionToNextRecord(DataInput dIn) throws IOException {
            if (this.eof) {
                throw new EOFException("Completed reading " + this.bytesRead);
            }
            this.currentKeyLength = WritableUtils.readVInt(dIn);
            this.currentValueLength = WritableUtils.readVInt(dIn);
            this.bytesRead += (long)(WritableUtils.getVIntSize(this.currentKeyLength) + WritableUtils.getVIntSize(this.currentValueLength));
            if (this.currentKeyLength == -1 && this.currentValueLength == -1) {
                this.eof = true;
                return false;
            }
            if (this.currentKeyLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + this.currentKeyLength);
            }
            if (this.currentValueLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + this.currentValueLength);
            }
            return true;
        }

        public boolean nextRawKey(DataInputBuffer key) throws IOException {
            int i;
            if (!this.positionToNextRecord(this.dataIn)) {
                return false;
            }
            if (this.keyBytes.length < this.currentKeyLength) {
                this.keyBytes = new byte[this.currentKeyLength << 1];
            }
            if ((i = this.readData(this.keyBytes, 0, this.currentKeyLength)) != this.currentKeyLength) {
                throw new IOException("Asked for " + this.currentKeyLength + " Got: " + i);
            }
            key.reset(this.keyBytes, this.currentKeyLength);
            this.bytesRead += (long)this.currentKeyLength;
            return true;
        }

        public void nextRawValue(DataInputBuffer value) throws IOException {
            byte[] valBytes = value.getData().length < this.currentValueLength ? new byte[this.currentValueLength << 1] : value.getData();
            int i = this.readData(valBytes, 0, this.currentValueLength);
            if (i != this.currentValueLength) {
                throw new IOException("Asked for " + this.currentValueLength + " Got: " + i);
            }
            value.reset(valBytes, this.currentValueLength);
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
            ++this.numRecordsRead;
        }

        public void close() throws IOException {
            this.in.close();
            this.dataIn = null;
            this.buffer = null;
            if (this.readRecordsCounter != null) {
                this.readRecordsCounter.increment(this.numRecordsRead);
            }
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor(this.decompressor);
                this.decompressor = null;
            }
        }

        public void reset(int offset) {
        }

        public void disableChecksumValidation() {
            this.checksumIn.disableChecksumValidation();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Writer<K, V> {
        FSDataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        FSDataOutputStream rawOut;
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        private long numRecordsWritten = 0L;
        private final Counters.Counter writtenRecordsCounter;
        IFileOutputStream checksumOut;
        Class<K> keyClass;
        Class<V> valueClass;
        Serializer<K> keySerializer;
        Serializer<V> valueSerializer;
        DataOutputBuffer buffer = new DataOutputBuffer();

        public Writer(Configuration conf, FileSystem fs, Path file, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Counters.Counter writesCounter) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec, writesCounter);
            this.ownOutputStream = true;
        }

        protected Writer(Counters.Counter writesCounter) {
            this.writtenRecordsCounter = writesCounter;
        }

        public Writer(Configuration conf, FSDataOutputStream out, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Counters.Counter writesCounter) throws IOException {
            this.writtenRecordsCounter = writesCounter;
            this.checksumOut = new IFileOutputStream(out);
            this.rawOut = out;
            this.start = this.rawOut.getPos();
            if (codec != null) {
                this.compressor = CodecPool.getCompressor(codec);
                if (this.compressor != null) {
                    this.compressor.reset();
                    this.compressedOut = codec.createOutputStream(this.checksumOut, this.compressor);
                    this.out = new FSDataOutputStream(this.compressedOut, null);
                    this.compressOutput = true;
                } else {
                    LOG.warn((Object)"Could not obtain compressor from CodecPool");
                    this.out = new FSDataOutputStream(this.checksumOut, null);
                }
            } else {
                this.out = new FSDataOutputStream(this.checksumOut, null);
            }
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            if (keyClass != null) {
                SerializationFactory serializationFactory = new SerializationFactory(conf);
                this.keySerializer = serializationFactory.getSerializer(keyClass);
                this.keySerializer.open(this.buffer);
                this.valueSerializer = serializationFactory.getSerializer(valueClass);
                this.valueSerializer.open(this.buffer);
            }
        }

        public Writer(Configuration conf, FileSystem fs, Path file) throws IOException {
            this(conf, fs, file, null, null, null, null);
        }

        public void close() throws IOException {
            if (this.keyClass != null) {
                this.keySerializer.close();
                this.valueSerializer.close();
            }
            WritableUtils.writeVInt(this.out, -1);
            WritableUtils.writeVInt(this.out, -1);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize(-1L));
            this.out.flush();
            if (this.compressOutput) {
                this.compressedOut.finish();
                this.compressedOut.resetState();
            }
            if (this.ownOutputStream) {
                this.out.close();
            } else {
                this.checksumOut.finish();
            }
            this.compressedBytesWritten = this.rawOut.getPos() - this.start;
            if (this.compressOutput) {
                CodecPool.returnCompressor(this.compressor);
                this.compressor = null;
            }
            this.out = null;
            if (this.writtenRecordsCounter != null) {
                this.writtenRecordsCounter.increment(this.numRecordsWritten);
            }
        }

        public void append(K key, V value) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass() + " is not " + this.keyClass);
            }
            if (value.getClass() != this.valueClass) {
                throw new IOException("wrong value class: " + value.getClass() + " is not " + this.valueClass);
            }
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            WritableUtils.writeVInt(this.out, keyLength);
            WritableUtils.writeVInt(this.out, valueLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
            this.buffer.reset();
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength));
            ++this.numRecordsWritten;
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            int valueLength = value.getLength() - value.getPosition();
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            WritableUtils.writeVInt(this.out, keyLength);
            WritableUtils.writeVInt(this.out, valueLength);
            this.out.write(key.getData(), key.getPosition(), keyLength);
            this.out.write(value.getData(), value.getPosition(), valueLength);
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength));
            ++this.numRecordsWritten;
        }

        public DataOutputStream getOutputStream() {
            return this.out;
        }

        public void updateCountersForExternalAppend(long length) {
            ++this.numRecordsWritten;
            this.decompressedBytesWritten += length;
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }
    }
}

