/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.Task;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCombineOutputCollector {
    private Task.CombineOutputCollector<String, Integer> coc;
    Counters.Counter outCounter = new Counters.Counter(){
        private long value;

        @Override
        public void setValue(long value) {
            this.value = value;
        }

        @Override
        public void setDisplayName(String displayName) {
        }

        @Override
        public void increment(long incr) {
            this.value += incr;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public String makeEscapedCompactString() {
            return null;
        }

        @Override
        public long getCounter() {
            return this.value;
        }

        @Override
        public boolean contentEquals(Counters.Counter counter) {
            return false;
        }

        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }
    };

    @Test
    public void testCustomCollect() throws Throwable {
        Task.TaskReporter mockTaskReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        IFile.Writer mockWriter = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        Configuration conf = new Configuration();
        conf.set("mapreduce.task.combine.progress.records", "2");
        this.coc = new Task.CombineOutputCollector(this.outCounter, mockTaskReporter, conf);
        this.coc.setWriter(mockWriter);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        this.coc.collect("dummy", 1);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        this.coc.collect("dummy", 2);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
    }

    @Test
    public void testDefaultCollect() throws Throwable {
        Task.TaskReporter mockTaskReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        IFile.Writer mockWriter = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        Configuration conf = new Configuration();
        this.coc = new Task.CombineOutputCollector(this.outCounter, mockTaskReporter, conf);
        this.coc.setWriter(mockWriter);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        int i = 0;
        while ((long)i < 10000L) {
            this.coc.collect("dummy", i);
            ++i;
        }
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
        i = 0;
        while ((long)i < 10000L) {
            this.coc.collect("dummy", i);
            ++i;
        }
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)2))).progress();
    }
}

