/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;

public class TestMRCJCFileOutputCommitter
extends TestCase {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), "output");
    private static String attempt = "attempt_200707121733_0001_m_000000_0";
    private static TaskAttemptID taskID = TaskAttemptID.forName(attempt);
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(RecordWriter theRecordWriter, Reporter reporter) throws IOException {
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write(this.key1, this.val1);
            theRecordWriter.write(null, nullWritable);
            theRecordWriter.write(null, this.val1);
            theRecordWriter.write(nullWritable, this.val2);
            theRecordWriter.write(this.key2, nullWritable);
            theRecordWriter.write(this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write(this.key2, this.val2);
        }
        finally {
            theRecordWriter.close(reporter);
        }
    }

    private void setConfForFileOutputCommitter(JobConf job) {
        job.set("mapreduce.task.attempt.id", attempt);
        job.setOutputCommitter(FileOutputCommitter.class);
        FileOutputFormat.setOutputPath(job, outDir);
    }

    public void testCommitter() throws Exception {
        JobConf job = new JobConf();
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath(job, committer.getTaskAttemptPath(tContext));
        committer.setupJob(jContext);
        committer.setupTask(tContext);
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        LocalFileSystem localFs = FileSystem.getLocal(job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(localFs, job, file, reporter);
        this.writeOutput(theRecordWriter, reporter);
        committer.commitTask(tContext);
        committer.commitJob(jContext);
        File expectedFile = new File(new Path(outDir, file).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = UtilsForTests.slurp(expectedFile);
        TestMRCJCFileOutputCommitter.assertEquals((String)output, (String)expectedOutput.toString());
        FileUtil.fullyDelete(new File(outDir.toString()));
    }

    public void testAbort() throws IOException {
        JobConf job = new JobConf();
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath(job, committer.getTaskAttemptPath(tContext));
        committer.setupJob(jContext);
        committer.setupTask(tContext);
        String file = "test.txt";
        Reporter reporter = Reporter.NULL;
        LocalFileSystem localFs = FileSystem.getLocal(job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(localFs, job, file, reporter);
        this.writeOutput(theRecordWriter, reporter);
        committer.abortTask(tContext);
        File expectedFile = new File(new Path(committer.getTaskAttemptPath(tContext), file).toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)"task temp dir still exists", (boolean)expectedFile.exists());
        committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        expectedFile = new File(new Path(outDir, "_temporary").toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)("job temp dir " + expectedFile + " still exists"), (boolean)expectedFile.exists());
        TestMRCJCFileOutputCommitter.assertEquals((String)"Output directory not empty", (int)0, (int)new File(outDir.toString()).listFiles().length);
        FileUtil.fullyDelete(new File(outDir.toString()));
    }

    public void testFailAbort() throws IOException {
        JobConf job = new JobConf();
        job.set("fs.defaultFS", "faildel:///");
        job.setClass("fs.faildel.impl", FakeFileSystem.class, FileSystem.class);
        this.setConfForFileOutputCommitter(job);
        JobContextImpl jContext = new JobContextImpl(job, (JobID)taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(job, taskID);
        FileOutputCommitter committer = new FileOutputCommitter();
        FileOutputFormat.setWorkOutputPath(job, committer.getTaskAttemptPath(tContext));
        committer.setupJob(jContext);
        committer.setupTask(tContext);
        String file = "test.txt";
        File jobTmpDir = new File(committer.getJobAttemptPath(jContext).toUri().getPath());
        File taskTmpDir = new File(committer.getTaskAttemptPath(tContext).toUri().getPath());
        File expectedFile = new File(taskTmpDir, file);
        Reporter reporter = Reporter.NULL;
        FakeFileSystem localFs = new FakeFileSystem();
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter(localFs, job, expectedFile.getAbsolutePath(), reporter);
        this.writeOutput(theRecordWriter, reporter);
        IOException th = null;
        try {
            committer.abortTask(tContext);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        TestMRCJCFileOutputCommitter.assertTrue((String)(expectedFile + " does not exists"), (boolean)expectedFile.exists());
        th = null;
        try {
            committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        TestMRCJCFileOutputCommitter.assertTrue((String)"job temp dir does not exists", (boolean)jobTmpDir.exists());
    }

    public static class FakeFileSystem
    extends RawLocalFileSystem {
        @Override
        public URI getUri() {
            return URI.create("faildel:///");
        }

        @Override
        public boolean delete(Path p, boolean recursive) throws IOException {
            throw new IOException("fake delete failed");
        }
    }
}

