/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.TestMRJobClient;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.util.Tool;
import org.junit.Ignore;

@Ignore
public class TestMRCJCJobClient
extends TestMRJobClient {
    private String runJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter(os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setJobPriority(JobPriority.HIGH);
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths(conf, this.getInputDir());
        FileOutputFormat.setOutputPath(conf, this.getOutputDir());
        return JobClient.runJob(conf).getID().toString();
    }

    public static int runTool(Configuration conf, Tool tool, String[] args, OutputStream out) throws Exception {
        return TestMRJobClient.runTool(conf, tool, args, out);
    }

    static void verifyJobPriority(String jobId, String priority, JobConf conf) throws Exception {
        TestMRCJCJobClient test = new TestMRCJCJobClient();
        test.verifyJobPriority(jobId, priority, conf, test.createJobClient());
    }

    @Override
    public void testJobClient() throws Exception {
        JobConf conf = this.createJobConf();
        String jobId = this.runJob();
        this.testGetCounter(jobId, conf);
        this.testAllJobList(jobId, conf);
        this.testChangingJobPriority(jobId, conf);
    }

    @Override
    protected CLI createJobClient() throws IOException {
        return new JobClient();
    }
}

