/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ClassUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestMRCJCJobConf {
    private static final String JAR_RELATIVE_PATH = "build/test/mapred/testjar/testjob.jar";
    private static final String CLASSNAME = "testjar.ClassWordCount";
    private static String TEST_DIR_WITH_SPECIAL_CHARS = System.getProperty("test.build.data", "/tmp") + File.separator + "test jobconf with + and spaces";

    @Test
    public void testFindContainingJar() throws Exception {
        this.testJarAtPath(JAR_RELATIVE_PATH);
    }

    @Test
    public void testFindContainingJarWithPlus() throws Exception {
        new File(TEST_DIR_WITH_SPECIAL_CHARS).mkdirs();
        Configuration conf = new Configuration();
        LocalFileSystem localfs = FileSystem.getLocal(conf);
        FileUtil.copy((FileSystem)localfs, new Path(JAR_RELATIVE_PATH), (FileSystem)localfs, new Path(TEST_DIR_WITH_SPECIAL_CHARS, "test.jar"), false, true, conf);
        this.testJarAtPath(TEST_DIR_WITH_SPECIAL_CHARS + File.separator + "test.jar");
    }

    private void testJarAtPath(String path) throws Exception {
        File jar = new File(path).getAbsoluteFile();
        Assert.assertTrue((boolean)jar.exists());
        URL[] urls = new URL[]{jar.toURI().toURL()};
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> clazz = Class.forName(CLASSNAME, true, cl);
        Assert.assertNotNull(clazz);
        String containingJar = ClassUtil.findContainingJar(clazz);
        Assert.assertEquals((Object)jar.getAbsolutePath(), (Object)containingJar);
    }
}

