/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMiniMRClientCluster {
    private static Path inDir = null;
    private static Path outDir = null;
    private static Path testdir = null;
    private static Path[] inFiles = new Path[5];
    private static MiniMRClientCluster mrCluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
        testdir = new Path(TEST_ROOT_DIR, "TestMiniMRClientCluster");
        inDir = new Path(testdir, "in");
        outDir = new Path(testdir, "out");
        LocalFileSystem fs = FileSystem.getLocal(conf);
        if (fs.exists(testdir) && !((FileSystem)fs).delete(testdir, true)) {
            throw new IOException("Could not delete " + testdir);
        }
        if (!((FileSystem)fs).mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir);
        }
        for (int i = 0; i < inFiles.length; ++i) {
            TestMiniMRClientCluster.inFiles[i] = new Path(inDir, "part_" + i);
            TestMiniMRClientCluster.createFile(inFiles[i], conf);
        }
        mrCluster = MiniMRClientClusterFactory.create(InternalClass.class, 1, new Configuration());
    }

    @AfterClass
    public static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = testdir.getFileSystem(conf);
        if (fs.exists(testdir)) {
            fs.delete(testdir, true);
        }
        mrCluster.stop();
    }

    @Test
    public void testRestart() throws Exception {
        String rmAddress1 = mrCluster.getConfig().get("yarn.resourcemanager.address");
        String rmAdminAddress1 = mrCluster.getConfig().get("yarn.resourcemanager.admin.address");
        String rmSchedAddress1 = mrCluster.getConfig().get("yarn.resourcemanager.scheduler.address");
        String rmRstrackerAddress1 = mrCluster.getConfig().get("yarn.resourcemanager.resource-tracker.address");
        String rmWebAppAddress1 = mrCluster.getConfig().get("yarn.resourcemanager.webapp.address");
        String mrHistAddress1 = mrCluster.getConfig().get("mapreduce.jobhistory.address");
        String mrHistWebAppAddress1 = mrCluster.getConfig().get("mapreduce.jobhistory.webapp.address");
        mrCluster.restart();
        String rmAddress2 = mrCluster.getConfig().get("yarn.resourcemanager.address");
        String rmAdminAddress2 = mrCluster.getConfig().get("yarn.resourcemanager.admin.address");
        String rmSchedAddress2 = mrCluster.getConfig().get("yarn.resourcemanager.scheduler.address");
        String rmRstrackerAddress2 = mrCluster.getConfig().get("yarn.resourcemanager.resource-tracker.address");
        String rmWebAppAddress2 = mrCluster.getConfig().get("yarn.resourcemanager.webapp.address");
        String mrHistAddress2 = mrCluster.getConfig().get("mapreduce.jobhistory.address");
        String mrHistWebAppAddress2 = mrCluster.getConfig().get("mapreduce.jobhistory.webapp.address");
        Assert.assertEquals((String)("Address before restart: " + rmAddress1 + " is different from new address: " + rmAddress2), (Object)rmAddress1, (Object)rmAddress2);
        Assert.assertEquals((String)("Address before restart: " + rmAdminAddress1 + " is different from new address: " + rmAdminAddress2), (Object)rmAdminAddress1, (Object)rmAdminAddress2);
        Assert.assertEquals((String)("Address before restart: " + rmSchedAddress1 + " is different from new address: " + rmSchedAddress2), (Object)rmSchedAddress1, (Object)rmSchedAddress2);
        Assert.assertEquals((String)("Address before restart: " + rmRstrackerAddress1 + " is different from new address: " + rmRstrackerAddress2), (Object)rmRstrackerAddress1, (Object)rmRstrackerAddress2);
        Assert.assertEquals((String)("Address before restart: " + rmWebAppAddress1 + " is different from new address: " + rmWebAppAddress2), (Object)rmWebAppAddress1, (Object)rmWebAppAddress2);
        Assert.assertEquals((String)("Address before restart: " + mrHistAddress1 + " is different from new address: " + mrHistAddress2), (Object)mrHistAddress1, (Object)mrHistAddress2);
        Assert.assertEquals((String)("Address before restart: " + mrHistWebAppAddress1 + " is different from new address: " + mrHistWebAppAddress2), (Object)mrHistWebAppAddress1, (Object)mrHistWebAppAddress2);
    }

    @Test
    public void testJob() throws Exception {
        Job job = TestMiniMRClientCluster.createJob();
        FileInputFormat.setInputPaths(job, inDir);
        FileOutputFormat.setOutputPath(job, new Path(outDir, "testJob"));
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        this.validateCounters(job.getCounters(), 5L, 25L, 5L, 5L);
    }

    private void validateCounters(Counters counters, long mapInputRecords, long mapOutputRecords, long reduceInputGroups, long reduceOutputRecords) {
        Assert.assertEquals((String)"MapInputRecords", (long)mapInputRecords, (long)counters.findCounter("MyCounterGroup", "MAP_INPUT_RECORDS").getValue());
        Assert.assertEquals((String)"MapOutputRecords", (long)mapOutputRecords, (long)counters.findCounter("MyCounterGroup", "MAP_OUTPUT_RECORDS").getValue());
        Assert.assertEquals((String)"ReduceInputGroups", (long)reduceInputGroups, (long)counters.findCounter("MyCounterGroup", "REDUCE_INPUT_GROUPS").getValue());
        Assert.assertEquals((String)"ReduceOutputRecords", (long)reduceOutputRecords, (long)counters.findCounter("MyCounterGroup", "REDUCE_OUTPUT_RECORDS").getValue());
    }

    private static void createFile(Path inFile, Configuration conf) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        if (fs.exists(inFile)) {
            return;
        }
        FSDataOutputStream out = fs.create(inFile);
        out.writeBytes("This is a test file");
        out.close();
    }

    public static Job createJob() throws IOException {
        Job baseJob = new Job(mrCluster.getConfig());
        baseJob.setOutputKeyClass(Text.class);
        baseJob.setOutputValueClass(IntWritable.class);
        baseJob.setMapperClass(MyMapper.class);
        baseJob.setReducerClass(MyReducer.class);
        baseJob.setNumReduceTasks(1);
        return baseJob;
    }

    public static class MyReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        @Override
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.getCounter("MyCounterGroup", "REDUCE_INPUT_GROUPS").increment(1L);
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write(key, this.result);
            context.getCounter("MyCounterGroup", "REDUCE_OUTPUT_RECORDS").increment(1L);
        }
    }

    public static class MyMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        @Override
        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter("MyCounterGroup", "MAP_INPUT_RECORDS").increment(1L);
            StringTokenizer iter = new StringTokenizer(value.toString());
            while (iter.hasMoreTokens()) {
                this.word.set(iter.nextToken());
                context.write(this.word, one);
                context.getCounter("MyCounterGroup", "MAP_OUTPUT_RECORDS").increment(1L);
            }
        }
    }

    private class InternalClass {
        private InternalClass() {
        }
    }
}

