/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileAsBinaryInputFormat;

public class TestSequenceFileAsBinaryInputFormat
extends TestCase {
    private static final Log LOG = FileInputFormat.LOG;
    private static final int RECORDS = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinary() throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal(job);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "testbinary.seq");
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        ((FileSystem)fs).delete(dir, true);
        FileInputFormat.setInputPaths(job, dir);
        Text tkey = new Text();
        Text tval = new Text();
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, job, file, Text.class, Text.class);
        try {
            for (int i = 0; i < 10000; ++i) {
                tkey.set(Integer.toString(r.nextInt(), 36));
                tval.set(Long.toString(r.nextLong(), 36));
                writer.append(tkey, tval);
            }
        }
        finally {
            writer.close();
        }
        SequenceFileAsBinaryInputFormat bformat = new SequenceFileAsBinaryInputFormat();
        int count = 0;
        r.setSeed(seed);
        BytesWritable bkey = new BytesWritable();
        BytesWritable bval = new BytesWritable();
        Text cmpkey = new Text();
        Text cmpval = new Text();
        DataInputBuffer buf = new DataInputBuffer();
        int NUM_SPLITS = 3;
        FileInputFormat.setInputPaths(job, file);
        for (InputSplit split : bformat.getSplits(job, 3)) {
            RecordReader<BytesWritable, BytesWritable> reader = bformat.getRecordReader(split, job, Reporter.NULL);
            try {
                while (reader.next(bkey, bval)) {
                    tkey.set(Integer.toString(r.nextInt(), 36));
                    tval.set(Long.toString(r.nextLong(), 36));
                    buf.reset(bkey.getBytes(), bkey.getLength());
                    cmpkey.readFields(buf);
                    buf.reset(bval.getBytes(), bval.getLength());
                    cmpval.readFields(buf);
                    TestSequenceFileAsBinaryInputFormat.assertTrue((String)("Keys don't match: *" + cmpkey.toString() + ":" + tkey.toString() + "*"), (boolean)cmpkey.toString().equals(tkey.toString()));
                    TestSequenceFileAsBinaryInputFormat.assertTrue((String)("Vals don't match: *" + cmpval.toString() + ":" + tval.toString() + "*"), (boolean)cmpval.toString().equals(tval.toString()));
                    ++count;
                }
            }
            finally {
                reader.close();
            }
        }
        TestSequenceFileAsBinaryInputFormat.assertEquals((String)"Some records not found", (int)10000, (int)count);
    }
}

