/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;

public class AggregatorTests
extends ValueAggregatorBaseDescriptor {
    @Override
    public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
        String[] words;
        ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
        for (String word : words = val.toString().split(" ")) {
            long numVal = Long.parseLong(word);
            String countType = "LongValueSum";
            String id = "count_" + word;
            Map.Entry<Text, Text> e = AggregatorTests.generateEntry(countType, id, ValueAggregatorDescriptor.ONE);
            if (e != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "LongValueMax", id = "max", new Text(word))) != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "LongValueMin", id = "min", new Text(word))) != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "StringValueMax", id = "value_as_string_max", new Text("" + numVal))) != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "StringValueMin", id = "value_as_string_min", new Text("" + numVal))) != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "UniqValueCount", id = "uniq_count", new Text(word))) != null) {
                retv.add(e);
            }
            if ((e = AggregatorTests.generateEntry(countType = "ValueHistogram", id = "histogram", new Text(word))) == null) continue;
            retv.add(e);
        }
        return retv;
    }
}

