/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.db;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.hadoop.mapred.lib.db.DBOutputFormat;
import org.apache.hadoop.mapred.lib.db.DBWritable;

public class TestConstructQuery
extends TestCase {
    private String[] fieldNames = new String[]{"id", "name", "value"};
    private String[] nullFieldNames = new String[]{null, null, null};
    private String expected = "INSERT INTO hadoop_output (id,name,value) VALUES (?,?,?);";
    private String nullExpected = "INSERT INTO hadoop_output VALUES (?,?,?);";
    private DBOutputFormat<DBWritable, NullWritable> format = new DBOutputFormat();

    public void testConstructQuery() {
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        TestConstructQuery.assertEquals((String)this.expected, (String)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        TestConstructQuery.assertEquals((String)this.nullExpected, (String)actual);
    }

    public void testSetOutput() throws IOException {
        JobConf job = new JobConf();
        DBOutputFormat.setOutput(job, "hadoop_output", this.fieldNames);
        DBConfiguration dbConf = new DBConfiguration(job);
        String actual = this.format.constructQuery(dbConf.getOutputTableName(), dbConf.getOutputFieldNames());
        TestConstructQuery.assertEquals((String)this.expected, (String)actual);
        job = new JobConf();
        dbConf = new DBConfiguration(job);
        DBOutputFormat.setOutput(job, "hadoop_output", this.nullFieldNames.length);
        TestConstructQuery.assertNull((Object)dbConf.getOutputFieldNames());
        TestConstructQuery.assertEquals((int)this.nullFieldNames.length, (int)dbConf.getOutputFieldCount());
        actual = this.format.constructQuery(dbConf.getOutputTableName(), new String[dbConf.getOutputFieldCount()]);
        TestConstructQuery.assertEquals((String)this.nullExpected, (String)actual);
    }
}

