/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.CombineTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Test;

public class TestCombineTextInputFormat {
    private static final Log LOG = LogFactory.getLog(TestCombineTextInputFormat.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFormat() throws Exception {
        Job job = Job.getInstance(new Configuration(defaultConf));
        Random random = new Random();
        long seed = random.nextLong();
        LOG.info((Object)("seed = " + seed));
        random.setSeed(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths(job, workDir);
        int length = 10000;
        int numFiles = 10;
        TestCombineTextInputFormat.createFiles(10000, 10, random);
        CombineTextInputFormat format = new CombineTextInputFormat();
        for (int i = 0; i < 3; ++i) {
            int numSplits = random.nextInt(500) + 1;
            LOG.info((Object)("splitting: requesting = " + numSplits));
            List<InputSplit> splits = format.getSplits(job);
            LOG.info((Object)("splitting: got =        " + splits.size()));
            Assert.assertEquals((String)"We got more than one splits!", (int)1, (int)splits.size());
            InputSplit split = splits.get(0);
            Assert.assertEquals((String)"It should be CombineFileSplit", CombineFileSplit.class, split.getClass());
            BitSet bits = new BitSet(10000);
            LOG.debug((Object)("split= " + split));
            TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
            RecordReader<LongWritable, Text> reader = format.createRecordReader(split, context);
            Assert.assertEquals((String)"reader class is CombineFileRecordReader.", CombineFileRecordReader.class, reader.getClass());
            MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
            reader.initialize(split, mcontext);
            try {
                int count = 0;
                while (reader.nextKeyValue()) {
                    LongWritable key = reader.getCurrentKey();
                    Assert.assertNotNull((String)"Key should not be null.", (Object)key);
                    Text value = reader.getCurrentValue();
                    int v = Integer.parseInt(value.toString());
                    LOG.debug((Object)("read " + v));
                    Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                    bits.set(v);
                    ++count;
                }
                LOG.debug((Object)("split=" + split + " count=" + count));
            }
            finally {
                reader.close();
            }
            Assert.assertEquals((String)"Some keys in no partition.", (int)10000, (int)bits.cardinality());
        }
    }

    private static Range[] createRanges(int length, int numFiles, Random random) {
        Range[] ranges = new Range[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            int start = i == 0 ? 0 : ranges[i - 1].end;
            int end = i == numFiles - 1 ? length : length / numFiles * (2 * i + 1) / 2 + random.nextInt(length / numFiles) + 1;
            ranges[i] = new Range(start, end);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFiles(int length, int numFiles, Random random) throws IOException {
        Range[] ranges = TestCombineTextInputFormat.createRanges(length, numFiles, random);
        for (int i = 0; i < numFiles; ++i) {
            Path file = new Path(workDir, "test_" + i + ".txt");
            OutputStreamWriter writer = new OutputStreamWriter(localFs.create(file));
            Range range = ranges[i];
            try {
                for (int j = range.start; j < range.end; ++j) {
                    writer.write(Integer.toString(j));
                    writer.write("\n");
                }
                continue;
            }
            finally {
                ((Writer)writer).close();
            }
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        OutputStream stm = codec == null ? fs.create(name) : codec.createOutputStream(fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(InputFormat<LongWritable, Text> format, InputSplit split, Job job) throws IOException, InterruptedException {
        ArrayList<Text> result = new ArrayList<Text>();
        Configuration conf = job.getConfiguration();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(conf);
        RecordReader<LongWritable, Text> reader = format.createRecordReader(split, MapReduceTestUtil.createDummyMapTaskAttemptContext(conf));
        MapContextImpl mcontext = new MapContextImpl(conf, context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
        reader.initialize(split, mcontext);
        while (reader.nextKeyValue()) {
            result.add(new Text(reader.getCurrentValue()));
        }
        return result;
    }

    @Test(timeout=10000L)
    public void testGzip() throws IOException, InterruptedException {
        Configuration conf = new Configuration(defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf(gzip, conf);
        localFs.delete(workDir, true);
        TestCombineTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), gzip, "the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        TestCombineTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), gzip, "this is a test\nof gzip\n");
        Job job = Job.getInstance(conf);
        FileInputFormat.setInputPaths(job, workDir);
        CombineTextInputFormat format = new CombineTextInputFormat();
        List<InputSplit> splits = format.getSplits(job);
        Assert.assertEquals((String)"compressed splits == 1", (int)1, (int)splits.size());
        List<Text> results = TestCombineTextInputFormat.readSplit(format, splits.get(0), job);
        Assert.assertEquals((String)"splits[0] length", (int)8, (int)results.size());
        String[] firstList = new String[]{"the quick", "brown", "fox jumped", "over", " the lazy", " dog"};
        String[] secondList = new String[]{"this is a test", "of gzip"};
        String first = results.get(0).toString();
        if (first.equals(firstList[0])) {
            TestCombineTextInputFormat.testResults(results, firstList, secondList);
        } else if (first.equals(secondList[0])) {
            TestCombineTextInputFormat.testResults(results, secondList, firstList);
        } else {
            Assert.fail((String)"unexpected first token!");
        }
    }

    private static void testResults(List<Text> results, String[] first, String[] second) {
        int i;
        for (i = 0; i < first.length; ++i) {
            Assert.assertEquals((String)("splits[0][" + i + "]"), (String)first[i], (String)results.get(i).toString());
        }
        for (i = 0; i < second.length; ++i) {
            int j = i + first.length;
            Assert.assertEquals((String)("splits[0][" + j + "]"), (String)second[i], (String)results.get(j).toString());
        }
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal(defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestCombineTextInputFormat");
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

