/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.util.BitSet;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsTextRecordReader;
import org.apache.hadoop.mapreduce.task.MapContextImpl;

public class TestMRSequenceFileAsTextInputFormat
extends TestCase {
    private static int MAX_LENGTH = 10000;
    private static Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        Job job = Job.getInstance(conf);
        LocalFileSystem fs = FileSystem.getLocal(conf);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        int seed = new Random().nextInt();
        Random random = new Random(seed);
        ((FileSystem)fs).delete(dir, true);
        FileInputFormat.setInputPaths(job, dir);
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            SequenceFile.Writer writer = SequenceFile.createWriter(fs, conf, file, IntWritable.class, LongWritable.class);
            try {
                for (int i = 0; i < length; ++i) {
                    IntWritable key = new IntWritable(i);
                    LongWritable value = new LongWritable(10 * i);
                    writer.append(key, value);
                }
            }
            finally {
                writer.close();
            }
            TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
            SequenceFileAsTextInputFormat format = new SequenceFileAsTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                BitSet bits = new BitSet(length);
                int numSplits = random.nextInt(MAX_LENGTH / 100) + 1;
                FileInputFormat.setMaxInputSplitSize(job, ((FileSystem)fs).getFileStatus(file).getLen() / (long)numSplits);
                for (InputSplit split : ((InputFormat)format).getSplits(job)) {
                    RecordReader reader = ((InputFormat)format).createRecordReader(split, context);
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                    reader.initialize(split, mcontext);
                    Class<?> readerClass = reader.getClass();
                    TestMRSequenceFileAsTextInputFormat.assertEquals((String)"reader class is SequenceFileAsTextRecordReader.", SequenceFileAsTextRecordReader.class, readerClass);
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            Text key = (Text)reader.getCurrentKey();
                            int keyInt = Integer.parseInt(key.toString());
                            TestMRSequenceFileAsTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(keyInt));
                            bits.set(keyInt);
                            ++count;
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                TestMRSequenceFileAsTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestMRSequenceFileAsTextInputFormat().testFormat();
    }
}

