/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.lib.partition.BinaryPartitioner;
import org.apache.hadoop.util.ReflectionUtils;

public class TestBinaryPartitioner
extends TestCase {
    public void testDefaultOffsets() {
        Configuration conf = new Configuration();
        BinaryPartitioner partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        int partition1 = partitioner.getPartition(key1, null, 10);
        int partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        key2 = new BytesWritable(new byte[]{6, 2, 3, 4, 5});
        partition1 = partitioner.getPartition(key1, null, 10);
        partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
        key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 6});
        partition1 = partitioner.getPartition(key1, null, 10);
        partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }

    public void testCustomOffsets() {
        Configuration conf = new Configuration();
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{6, 2, 3, 7, 8});
        BinaryPartitioner.setOffsets(conf, 1, -3);
        BinaryPartitioner partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        int partition1 = partitioner.getPartition(key1, null, 10);
        int partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        BinaryPartitioner.setOffsets(conf, 1, 2);
        partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        partition1 = partitioner.getPartition(key1, null, 10);
        partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        BinaryPartitioner.setOffsets(conf, -4, -3);
        partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        partition1 = partitioner.getPartition(key1, null, 10);
        partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
    }

    public void testLowerBound() {
        Configuration conf = new Configuration();
        BinaryPartitioner.setLeftOffset(conf, 0);
        BinaryPartitioner partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{6, 2, 3, 4, 5});
        int partition1 = partitioner.getPartition(key1, null, 10);
        int partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }

    public void testUpperBound() {
        Configuration conf = new Configuration();
        BinaryPartitioner.setRightOffset(conf, 4);
        BinaryPartitioner partitioner = ReflectionUtils.newInstance(BinaryPartitioner.class, conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 6});
        int partition1 = partitioner.getPartition(key1, null, 10);
        int partition2 = partitioner.getPartition(key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }
}

