/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class PartialJob
implements Job {
    private static final Log LOG = LogFactory.getLog(PartialJob.class);
    private JobIndexInfo jobIndexInfo = null;
    private JobId jobId = null;
    private JobReport jobReport = null;

    public PartialJob(JobIndexInfo jobIndexInfo, JobId jobId) {
        this.jobIndexInfo = jobIndexInfo;
        this.jobId = jobId;
        this.jobReport = RecordFactoryProvider.getRecordFactory(null).newRecordInstance(JobReport.class);
        this.jobReport.setSubmitTime(jobIndexInfo.getSubmitTime());
        this.jobReport.setStartTime(jobIndexInfo.getJobStartTime());
        this.jobReport.setFinishTime(jobIndexInfo.getFinishTime());
        this.jobReport.setJobState(this.getState());
    }

    @Override
    public JobId getID() {
        return this.jobId;
    }

    @Override
    public String getName() {
        return this.jobIndexInfo.getJobName();
    }

    @Override
    public String getQueueName() {
        return this.jobIndexInfo.getQueueName();
    }

    @Override
    public JobState getState() {
        JobState js = null;
        try {
            js = JobState.valueOf(this.jobIndexInfo.getJobStatus());
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while parsing job state. Defaulting to KILLED", (Throwable)e);
            js = JobState.KILLED;
        }
        return js;
    }

    @Override
    public JobReport getReport() {
        return this.jobReport;
    }

    @Override
    public float getProgress() {
        return 1.0f;
    }

    @Override
    public Counters getAllCounters() {
        return null;
    }

    @Override
    public Map<TaskId, Task> getTasks() {
        return null;
    }

    @Override
    public Map<TaskId, Task> getTasks(TaskType taskType) {
        return null;
    }

    @Override
    public Task getTask(TaskId taskID) {
        return null;
    }

    @Override
    public List<String> getDiagnostics() {
        return null;
    }

    @Override
    public int getTotalMaps() {
        return this.jobIndexInfo.getNumMaps();
    }

    @Override
    public int getTotalReduces() {
        return this.jobIndexInfo.getNumReduces();
    }

    @Override
    public int getCompletedMaps() {
        return this.jobIndexInfo.getNumMaps();
    }

    @Override
    public int getCompletedReduces() {
        return this.jobIndexInfo.getNumReduces();
    }

    @Override
    public boolean isUber() {
        return false;
    }

    @Override
    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        return null;
    }

    @Override
    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        return null;
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        return true;
    }

    @Override
    public String getUserName() {
        return this.jobIndexInfo.getUser();
    }

    @Override
    public Path getConfFile() {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Configuration loadConfFile() {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Map<JobACL, AccessControlList> getJobACLs() {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public List<AMInfo> getAMInfos() {
        return null;
    }

    @Override
    public void setQueueName(String queueName) {
        throw new UnsupportedOperationException("Can't set job's queue name in history");
    }
}

