/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTaskPage;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.SubView;

public class HsAttemptsPage
extends HsTaskPage {
    @Override
    protected Class<? extends SubView> content() {
        return FewAttemptsBlock.class;
    }

    static class FewAttemptsBlock
    extends HsTaskPage.AttemptsBlock {
        @Inject
        FewAttemptsBlock(App ctx) {
            super(ctx);
        }

        @Override
        protected boolean isValidRequest() {
            return this.app.getJob() != null;
        }

        @Override
        protected Collection<TaskAttempt> getTaskAttempts() {
            ArrayList<TaskAttempt> fewTaskAttemps = new ArrayList<TaskAttempt>();
            String taskTypeStr = this.$("task.type");
            TaskType taskType = MRApps.taskType(taskTypeStr);
            String attemptStateStr = this.$("attempt.state");
            MRApps.TaskAttemptStateUI neededState = MRApps.taskAttemptState(attemptStateStr);
            Job j = this.app.getJob();
            Map<TaskId, Task> tasks = j.getTasks(taskType);
            for (Task task : tasks.values()) {
                Map<TaskAttemptId, TaskAttempt> attempts = task.getAttempts();
                for (TaskAttempt attempt : attempts.values()) {
                    if (!neededState.correspondsTo(attempt.getState())) continue;
                    fewTaskAttemps.add(attempt);
                }
            }
            return fewTaskAttemps;
        }
    }
}

