/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsView;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class HsTaskPage
extends HsView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID("ui.accordion", "nav"), "{autoHeight:false, active:2}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID("ui.dataTables", "attempts"), this.attemptsTableInit());
        this.set(JQueryUI.postInitID("ui.dataTables", "attempts"), this.attemptsPostTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType(symbol);
        } else {
            TaskId taskID = MRApps.toTaskID(this.$("task.id"));
            type = taskID.getTaskType();
        }
        StringBuilder b = JQueryUI.tableInit().append(", 'aaData': attemptsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n,aoColumnDefs:[\n").append("\n{'aTargets': [ 4 ]").append(", 'bSearchable': false }").append("\n, {'sType':'numeric', 'aTargets': [ 0 ]").append(", 'mRender': parseHadoopAttemptID }").append("\n, {'sType':'numeric', 'aTargets': [ 5, 6").append(type == TaskType.REDUCE ? ", 7, 8" : "").append(" ], 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', 'aTargets': [").append(type == TaskType.REDUCE ? "9, 10, 11, 12" : "7").append(" ], 'mRender': renderHadoopElapsedTime }]").append("\n, aaSorting: [[0, 'asc']]").append("}");
        return b.toString();
    }

    private String attemptsPostTableInit() {
        return "var asInitVals = new Array();\n$('tfoot input').keyup( function () \n{  attemptsDataTable.fnFilter( this.value, $('tfoot input').index(this) );\n} );\n$('tfoot input').each( function (i) {\n  asInitVals[i] = this.value;\n} );\n$('tfoot input').focus( function () {\n  if ( this.className == 'search_init' )\n  {\n    this.className = '';\n    this.value = '';\n  }\n} );\n$('tfoot input').blur( function (i) {\n  if ( this.value == '' )\n  {\n    this.className = 'search_init';\n    this.value = asInitVals[$('tfoot input').index(this)];\n  }\n} );\n";
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;

        @Inject
        AttemptsBlock(App ctx) {
            this.app = ctx;
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            TaskType type = null;
            String symbol = this.$("task.type");
            type = !symbol.isEmpty() ? MRApps.taskType(symbol) : this.app.getTask().getType();
            HamletSpec.TR headRow = ((Hamlet.THEAD)((Hamlet.TABLE)html.table("#attempts")).thead()).tr();
            ((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)headRow).th(".id", "Attempt")).th(".state", "State")).th(".status", "Status")).th(".node", "Node")).th(".logs", "Logs")).th(".tsh", "Start Time");
            if (type == TaskType.REDUCE) {
                ((Hamlet.TR)headRow).th("Shuffle Finish Time");
                ((Hamlet.TR)headRow).th("Merge Finish Time");
            }
            ((Hamlet.TR)headRow).th("Finish Time");
            if (type == TaskType.REDUCE) {
                ((Hamlet.TR)headRow).th("Elapsed Time Shuffle");
                ((Hamlet.TR)headRow).th("Elapsed Time Merge");
                ((Hamlet.TR)headRow).th("Elapsed Time Reduce");
            }
            ((Hamlet.TR)((Hamlet.TR)headRow).th("Elapsed Time")).th(".note", "Note");
            HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)headRow))._())._()).tbody();
            StringBuilder attemptsTableData = new StringBuilder("[\n");
            for (TaskAttempt attempt : this.getTaskAttempts()) {
                TaskAttemptInfo ta = new TaskAttemptInfo(attempt, false);
                String taid = ta.getId();
                String nodeHttpAddr = ta.getNode();
                String containerIdString = ta.getAssignedContainerIdStr();
                String nodeIdString = attempt.getAssignedContainerMgrAddress();
                String nodeRackName = ta.getRack();
                long attemptStartTime = ta.getStartTime();
                long shuffleFinishTime = -1L;
                long sortFinishTime = -1L;
                long attemptFinishTime = ta.getFinishTime();
                long elapsedShuffleTime = -1L;
                long elapsedSortTime = -1L;
                long elapsedReduceTime = -1L;
                if (type == TaskType.REDUCE) {
                    shuffleFinishTime = attempt.getShuffleFinishTime();
                    sortFinishTime = attempt.getSortFinishTime();
                    elapsedShuffleTime = Times.elapsed(attemptStartTime, shuffleFinishTime, false);
                    elapsedSortTime = Times.elapsed(shuffleFinishTime, sortFinishTime, false);
                    elapsedReduceTime = Times.elapsed(sortFinishTime, attemptFinishTime, false);
                }
                long attemptElapsed = Times.elapsed(attemptStartTime, attemptFinishTime, false);
                int sortId = attempt.getID().getId() + attempt.getID().getTaskId().getId() * 10000;
                attemptsTableData.append("[\"").append(sortId + " ").append(taid).append("\",\"").append(ta.getState()).append("\",\"").append(ta.getStatus()).append("\",\"").append("<a class='nodelink' href='" + MRWebAppUtil.getYARNWebappScheme() + nodeHttpAddr + "'>").append(nodeRackName + "/" + nodeHttpAddr + "</a>\",\"").append("<a class='logslink' href='").append(this.url("logs", nodeIdString, containerIdString, taid, this.app.getJob().getUserName())).append("'>logs</a>\",\"").append(attemptStartTime).append("\",\"");
                if (type == TaskType.REDUCE) {
                    attemptsTableData.append(shuffleFinishTime).append("\",\"").append(sortFinishTime).append("\",\"");
                }
                attemptsTableData.append(attemptFinishTime).append("\",\"");
                if (type == TaskType.REDUCE) {
                    attemptsTableData.append(elapsedShuffleTime).append("\",\"").append(elapsedSortTime).append("\",\"").append(elapsedReduceTime).append("\",\"");
                }
                attemptsTableData.append(attemptElapsed).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)ta.getNote()))).append("\"],\n");
            }
            if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
                attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
            }
            attemptsTableData.append("]");
            ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var attemptsTableData=" + attemptsTableData})))._();
            HamletSpec.TR footRow = ((Hamlet.TFOOT)((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._()).tfoot()).tr();
            ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_name")).$value("Attempt")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_state")).$value("State")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_status")).$value("Status")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_node")).$value("Node")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_node")).$value("Logs")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_start_time")).$value("Start Time")))._())._();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("shuffle_time")).$value("Shuffle Time")))._())._();
                ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("merge_time")).$value("Merge Time")))._())._();
            }
            ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_finish")).$value("Finish Time")))._())._();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("elapsed_shuffle_time")).$value("Elapsed Shuffle Time")))._())._();
                ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("elapsed_merge_time")).$value("Elapsed Merge Time")))._())._();
                ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("elapsed_reduce_time")).$value("Elapsed Reduce Time")))._())._();
            }
            ((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((HamletImpl.EImp)((Object)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.INPUT)((Hamlet.TH)((Hamlet.TR)footRow).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("attempt_elapsed")).$value("Elapsed Time")))._())._()).th()).input("search_init")).$type(HamletSpec.InputType.text)).$name("note")).$value("Note")))._())._();
            ((Hamlet.TABLE)((Hamlet.TFOOT)((HamletImpl.EImp)((Object)footRow))._())._())._();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

