/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.junit.Assert;
import org.junit.Test;

public class TestNetworkTopologyWithNodeGroup {
    private static final NetworkTopologyWithNodeGroup cluster = new NetworkTopologyWithNodeGroup();
    private static final NodeBase[] dataNodes = new NodeBase[]{new NodeBase("h1", "/d1/r1/s1"), new NodeBase("h2", "/d1/r1/s1"), new NodeBase("h3", "/d1/r1/s2"), new NodeBase("h4", "/d1/r2/s3"), new NodeBase("h5", "/d1/r2/s3"), new NodeBase("h6", "/d1/r2/s4"), new NodeBase("h7", "/d2/r3/s5"), new NodeBase("h8", "/d2/r3/s6")};
    private static final NodeBase computeNode = new NodeBase("/d1/r1/s1/h9");
    private static final NodeBase rackOnlyNode = new NodeBase("h10", "/r2");

    @Test
    public void testNumOfChildren() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfLeaves(), (long)dataNodes.length);
    }

    @Test
    public void testNumOfRacks() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfRacks(), (long)3L);
    }

    @Test
    public void testRacks() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfRacks(), (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack(dataNodes[0], dataNodes[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack(dataNodes[1], dataNodes[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack(dataNodes[2], dataNodes[3]));
        Assert.assertTrue((boolean)cluster.isOnSameRack(dataNodes[3], dataNodes[4]));
        Assert.assertTrue((boolean)cluster.isOnSameRack(dataNodes[4], dataNodes[5]));
        Assert.assertFalse((boolean)cluster.isOnSameRack(dataNodes[5], dataNodes[6]));
        Assert.assertTrue((boolean)cluster.isOnSameRack(dataNodes[6], dataNodes[7]));
    }

    @Test
    public void testNodeGroups() throws Exception {
        Assert.assertEquals((long)cluster.getNumOfRacks(), (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameNodeGroup(dataNodes[0], dataNodes[1]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup(dataNodes[1], dataNodes[2]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup(dataNodes[2], dataNodes[3]));
        Assert.assertTrue((boolean)cluster.isOnSameNodeGroup(dataNodes[3], dataNodes[4]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup(dataNodes[4], dataNodes[5]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup(dataNodes[5], dataNodes[6]));
        Assert.assertFalse((boolean)cluster.isOnSameNodeGroup(dataNodes[6], dataNodes[7]));
    }

    @Test
    public void testGetDistance() throws Exception {
        Assert.assertEquals((long)cluster.getDistance(dataNodes[0], dataNodes[0]), (long)0L);
        Assert.assertEquals((long)cluster.getDistance(dataNodes[0], dataNodes[1]), (long)2L);
        Assert.assertEquals((long)cluster.getDistance(dataNodes[0], dataNodes[2]), (long)4L);
        Assert.assertEquals((long)cluster.getDistance(dataNodes[0], dataNodes[3]), (long)6L);
        Assert.assertEquals((long)cluster.getDistance(dataNodes[0], dataNodes[6]), (long)8L);
    }

    @Test
    public void testPseudoSortByDistance() throws Exception {
        Node[] testNodes = new NodeBase[]{dataNodes[1], dataNodes[2], dataNodes[3], dataNodes[0]};
        cluster.pseudoSortByDistance(dataNodes[0], testNodes);
        Assert.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[2] == dataNodes[2] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[3] == dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[3];
        testNodes[1] = dataNodes[4];
        testNodes[2] = dataNodes[1];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance(dataNodes[0], testNodes);
        Assert.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[5];
        testNodes[1] = dataNodes[3];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance(dataNodes[0], testNodes);
        Assert.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[6];
        testNodes[1] = dataNodes[7];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance(computeNode, testNodes);
        Assert.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (NodeBase dnd : dataNodes) {
            frequency.put(dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    @Test
    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath(dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (NodeBase key : dataNodes) {
            Assert.assertTrue((frequency.get(key) > 0 || key == dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddNodeWithInvalidTopology() {
        try {
            cluster.add(rackOnlyNode);
            Assert.fail((String)"Exception should be thrown, so we should not have reached here.");
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                Assert.fail((String)("Expecting IllegalArgumentException, but caught:" + e));
            }
            Assert.assertTrue((boolean)e.getMessage().contains("illegal network location"));
        }
    }

    static {
        for (int i = 0; i < dataNodes.length; ++i) {
            cluster.add(dataNodes[i]);
        }
    }
}

