/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.hadoop.shaded.com.google.common.io.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.TableMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestTableMapping {
    @Test
    public void testResolve() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testResolve", ".txt");
        Files.write("a.b.c /rack1\n1.2.3.4\t/rack2\n", mapFile, Charsets.UTF_8);
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", (Object)result.get(0));
        Assert.assertEquals((Object)"/rack2", (Object)result.get(1));
    }

    @Test
    public void testTableCaching() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testTableCaching", ".txt");
        Files.write("a.b.c /rack1\n1.2.3.4\t/rack2\n", mapFile, Charsets.UTF_8);
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result1 = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result1.size());
        Assert.assertEquals((Object)"/rack1", (Object)result1.get(0));
        Assert.assertEquals((Object)"/rack2", (Object)result1.get(1));
        conf.set("net.topology.table.file.name", "some bad value for a file");
        List<String> result2 = mapping.resolve(names);
        Assert.assertEquals(result1, result2);
    }

    @Test
    public void testNoFile() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", (Object)result.get(0));
        Assert.assertEquals((Object)"/default-rack", (Object)result.get(1));
    }

    @Test
    public void testFileDoesNotExist() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", "/this/file/does/not/exist");
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"/default-rack");
        Assert.assertEquals((Object)result.get(1), (Object)"/default-rack");
    }

    @Test
    public void testClearingCachedMappings() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testClearingCachedMappings", ".txt");
        Files.write("a.b.c /rack1\n1.2.3.4\t/rack2\n", mapFile, Charsets.UTF_8);
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", (Object)result.get(0));
        Assert.assertEquals((Object)"/rack2", (Object)result.get(1));
        Files.write("", mapFile, Charsets.UTF_8);
        mapping.reloadCachedMappings();
        names = new ArrayList();
        names.add("a.b.c");
        names.add("1.2.3.4");
        result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", (Object)result.get(0));
        Assert.assertEquals((Object)"/default-rack", (Object)result.get(1));
    }

    @Test(timeout=60000L)
    public void testBadFile() throws IOException {
        File mapFile = File.createTempFile(this.getClass().getSimpleName() + ".testBadFile", ".txt");
        Files.write("bad contents", mapFile, Charsets.UTF_8);
        mapFile.deleteOnExit();
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", mapFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List<String> result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)result.get(0), (Object)"/default-rack");
        Assert.assertEquals((Object)result.get(1), (Object)"/default-rack");
    }
}

