/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestGroupFallback {
    public static final Log LOG = LogFactory.getLog(TestGroupFallback.class);

    @Test
    public void testGroupShell() throws Exception {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.ShellBasedUnixGroupsMapping");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List<String> groupList = groups.getGroups(username);
        LOG.info((Object)(username + " has GROUPS: " + groupList.toString()));
        Assert.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNetgroupShell() throws Exception {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMapping");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List<String> groupList = groups.getGroups(username);
        LOG.info((Object)(username + " has GROUPS: " + groupList.toString()));
        Assert.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupWithFallback() throws Exception {
        LOG.info((Object)"running 'mvn -Pnative -DTestGroupFallback clear test' will test the normal path and 'mvn -DTestGroupFallback clear test' will test the fall back functionality");
        Logger.getRootLogger().setLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List<String> groupList = groups.getGroups(username);
        LOG.info((Object)(username + " has GROUPS: " + groupList.toString()));
        Assert.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNetgroupWithFallback() throws Exception {
        LOG.info((Object)"running 'mvn -Pnative -DTestGroupFallback clear test' will test the normal path and 'mvn -DTestGroupFallback clear test' will test the fall back functionality");
        Logger.getRootLogger().setLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsNetgroupMappingWithFallback");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List<String> groupList = groups.getGroups(username);
        LOG.info((Object)(username + " has GROUPS: " + groupList.toString()));
        Assert.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }
}

