/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestUGIWithExternalKdc {
    @Before
    public void testExternalKdcRunning() {
        Assume.assumeTrue((boolean)SecurityUtilTestHelper.isExternalKdcRunning());
    }

    @Test
    public void testLogin() throws IOException {
        String userPrincipal = System.getProperty("user.principal");
        String userKeyTab = System.getProperty("user.keytab");
        Assert.assertNotNull((String)"User principal was not specified", (Object)userPrincipal);
        Assert.assertNotNull((String)"User keytab was not specified", (Object)userKeyTab);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(conf);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI(userPrincipal, userKeyTab);
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.KERBEROS), (Object)((Object)ugi.getAuthenticationMethod()));
        try {
            UserGroupInformation.loginUserFromKeytabAndReturnUGI("bogus@EXAMPLE.COM", userKeyTab);
            Assert.fail((String)"Login should have failed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

