/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.TestDelegationToken;

public class TestToken
extends TestCase {
    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    static boolean checkEqual(Token<TokenIdentifier> a, Token<TokenIdentifier> b) {
        return Arrays.equals(a.getIdentifier(), b.getIdentifier()) && Arrays.equals(a.getPassword(), b.getPassword()) && TestToken.isEqual(a.getKind(), b.getKind()) && TestToken.isEqual(a.getService(), b.getService());
    }

    public void testTokenSerialization() throws IOException {
        Token<TokenIdentifier> sourceToken = new Token<TokenIdentifier>();
        sourceToken.setService(new Text("service"));
        DataOutputBuffer out = new DataOutputBuffer();
        sourceToken.write(out);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        Token<TokenIdentifier> destToken = new Token<TokenIdentifier>();
        destToken.readFields(in);
        TestToken.assertTrue((boolean)TestToken.checkEqual(sourceToken, destToken));
    }

    private static void checkUrlSafe(String str) throws Exception {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '-' || ch == '_' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            TestToken.fail((String)("Encoded string " + str + " has invalid character at position " + i));
        }
    }

    public static void testEncodeWritable() throws Exception {
        String[] values = new String[]{"", "a", "bb", "ccc", "dddd", "eeeee", "ffffff", "ggggggg", "hhhhhhhh", "iiiiiiiii", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890!@#$%^&*()-=_+[]{}|;':,./<>?"};
        Token copy = new Token();
        for (int i = 0; i < values.length; ++i) {
            String val = values[i];
            System.out.println("Input = " + val);
            Token orig = new Token(val.getBytes(), val.getBytes(), new Text(val), new Text(val));
            String encode = orig.encodeToUrlString();
            copy.decodeFromUrlString(encode);
            TestToken.assertEquals(orig, copy);
            TestToken.checkUrlSafe(encode);
        }
    }

    public void testDecodeIdentifier() throws IOException {
        TestDelegationToken.TestDelegationTokenSecretManager secretManager = new TestDelegationToken.TestDelegationTokenSecretManager(0L, 0L, 0L, 0L);
        secretManager.startThreads();
        TestDelegationToken.TestDelegationTokenIdentifier id = new TestDelegationToken.TestDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("realUser"));
        Token<TestDelegationToken.TestDelegationTokenIdentifier> token = new Token<TestDelegationToken.TestDelegationTokenIdentifier>(id, secretManager);
        TestDelegationToken.TestDelegationTokenIdentifier idCopy = token.decodeIdentifier();
        TestToken.assertNotSame((Object)id, (Object)idCopy);
        TestToken.assertEquals((Object)id, (Object)idCopy);
    }
}

