/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompositeService {
    private static final int NUM_OF_SERVICES = 5;
    private static final int FAILED_SERVICE_SEQ_NUMBER = 2;
    private static final Log LOG = LogFactory.getLog(TestCompositeService.class);
    private static final boolean STOP_ONLY_STARTED_SERVICES = CompositeServiceImpl.isPolicyToStopOnlyStartedServices();

    @Before
    public void setup() {
        CompositeServiceImpl.resetCounter();
    }

    @Test
    public void testCallSequence() {
        int i;
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i2 = 0; i2 < 5; ++i2) {
            CompositeServiceImpl service = new CompositeServiceImpl(i2);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Assert.assertEquals((String)"Number of registered services ", (long)5L, (long)services.length);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        this.assertInState(Service.STATE.INITED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, init() call sequence number should have been "), (long)i, (long)services[i].getCallSequenceNumber());
        }
        this.resetServices(services);
        serviceManager.start();
        this.assertInState(Service.STATE.STARTED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, start() call sequence number should have been "), (long)i, (long)services[i].getCallSequenceNumber());
        }
        this.resetServices(services);
        serviceManager.stop();
        this.assertInState(Service.STATE.STOPPED, services);
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, stop() call sequence number should have been "), (long)(4 - i), (long)services[i].getCallSequenceNumber());
        }
        serviceManager.stop();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("For " + services[i] + " service, stop() call sequence number should have been "), (long)(4 - i), (long)services[i].getCallSequenceNumber());
        }
    }

    private void resetServices(CompositeServiceImpl[] services) {
        for (int i = 0; i < 5; ++i) {
            services[i].reset();
        }
    }

    @Test
    public void testServiceStartup() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStart(true);
            }
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        try {
            serviceManager.start();
            Assert.fail((String)"Exception should have been thrown due to startup failure of last service");
        }
        catch (ServiceTestRuntimeException e) {
            for (int i = 0; i < 4; ++i) {
                if (i >= 2 && STOP_ONLY_STARTED_SERVICES) {
                    Assert.assertEquals((String)"Service state should have been ", (Object)((Object)Service.STATE.INITED), (Object)((Object)services[4].getServiceState()));
                    continue;
                }
                Assert.assertEquals((String)"Service state should have been ", (Object)((Object)Service.STATE.STOPPED), (Object)((Object)services[i].getServiceState()));
            }
        }
    }

    @Test
    public void testServiceStop() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStop(true);
            }
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        serviceManager.start();
        try {
            serviceManager.stop();
        }
        catch (ServiceTestRuntimeException e) {
            // empty catch block
        }
        this.assertInState(Service.STATE.STOPPED, services);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services) {
        this.assertInState(expected, services, 0, services.length);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services, int start, int finish) {
        for (int i = start; i < finish; ++i) {
            CompositeServiceImpl service = services[i];
            this.assertInState(expected, service);
        }
    }

    private void assertInState(Service.STATE expected, Service service) {
        Assert.assertEquals((String)("Service state should have been " + (Object)((Object)expected) + " in " + service), (Object)((Object)expected), (Object)((Object)service.getServiceState()));
    }

    @Test
    public void testServiceStopFromNotInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.stop();
        this.assertInState(Service.STATE.NOTINITED, services);
    }

    @Test
    public void testServiceStopFromInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.init(new Configuration());
        serviceManager.stop();
        if (STOP_ONLY_STARTED_SERVICES) {
            this.assertInState(Service.STATE.INITED, services);
        } else {
            this.assertInState(Service.STATE.STOPPED, services);
        }
    }

    @Test
    public void testInitNullConf() throws Throwable {
        ServiceManager serviceManager = new ServiceManager("testInitNullConf");
        CompositeServiceImpl service = new CompositeServiceImpl(0);
        serviceManager.addTestService(service);
        try {
            serviceManager.init(null);
            LOG.warn((Object)("Null Configurations are permitted " + serviceManager));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
    }

    @Test
    public void testServiceLifecycleNoChildren() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        serviceManager.init(new Configuration());
        serviceManager.start();
        serviceManager.stop();
    }

    @Test
    public void testAddServiceInInit() throws Throwable {
        BreakableService child = new BreakableService();
        this.assertInState(Service.STATE.NOTINITED, child);
        CompositeServiceAddingAChild composite = new CompositeServiceAddingAChild(child);
        composite.init(new Configuration());
        this.assertInState(Service.STATE.INITED, child);
    }

    @Test(timeout=1000L)
    public void testAddIfService() {
        CompositeService testService = new CompositeService("TestService"){
            Service service;

            @Override
            public void serviceInit(Configuration conf) {
                Integer notAService = new Integer(0);
                Assert.assertFalse((String)"Added an integer as a service", (boolean)this.addIfService(notAService));
                this.service = new AbstractService("Service"){};
                Assert.assertTrue((String)"Unable to add a service", (boolean)this.addIfService(this.service));
            }
        };
        testService.init(new Configuration());
        Assert.assertEquals((String)"Incorrect number of services", (long)1L, (long)testService.getServices().size());
    }

    @Test(timeout=1000L)
    public void testAddInitedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
    }

    @Test(timeout=1000L)
    public void testAddUninitedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        try {
            parent.start();
            Assert.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
    }

    @Test
    public void testRemoveService() {
        CompositeService testService = new CompositeService("TestService"){

            @Override
            public void serviceInit(Configuration conf) {
                Integer notAService = new Integer(0);
                Assert.assertFalse((String)"Added an integer as a service", (boolean)this.addIfService(notAService));
                AbstractService service1 = new AbstractService("Service1"){};
                this.addIfService(service1);
                AbstractService service2 = new AbstractService("Service2"){};
                this.addIfService(service2);
                AbstractService service3 = new AbstractService("Service3"){};
                this.addIfService(service3);
                this.removeService(service1);
            }
        };
        testService.init(new Configuration());
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)testService.getServices().size());
    }

    @Test(timeout=1000L)
    public void testAddStartedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        AddSiblingService.addChildToService(parent, child);
        try {
            parent.init(new Configuration());
            Assert.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
    }

    @Test(timeout=1000L)
    public void testAddStoppedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        child.stop();
        AddSiblingService.addChildToService(parent, child);
        try {
            parent.init(new Configuration());
            Assert.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
    }

    @Test(timeout=1000L)
    public void testAddStartedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
    }

    @Test(timeout=1000L)
    public void testAddUninitedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.NOTINITED, sibling);
        parent.start();
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
    }

    @Test(timeout=1000L)
    public void testAddStartedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STARTED, sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, sibling);
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
        this.assertInState(Service.STATE.STOPPED, sibling);
    }

    @Test(timeout=1000L)
    public void testAddStartedSiblingInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService(new AddSiblingService(parent, sibling, Service.STATE.STOPPED));
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        Assert.assertEquals((String)"Incorrect number of services", (long)2L, (long)parent.getServices().size());
    }

    public static class AddSiblingService
    extends CompositeService {
        private final CompositeService parent;
        private final Service serviceToAdd;
        private Service.STATE triggerState;

        public AddSiblingService(CompositeService parent, Service serviceToAdd, Service.STATE triggerState) {
            super("ParentStateManipulatorService");
            this.parent = parent;
            this.serviceToAdd = serviceToAdd;
            this.triggerState = triggerState;
        }

        private void maybeAddSibling() {
            if (this.getServiceState() == this.triggerState) {
                this.parent.addService(this.serviceToAdd);
            }
        }

        @Override
        protected void serviceInit(Configuration conf) throws Exception {
            this.maybeAddSibling();
            super.serviceInit(conf);
        }

        @Override
        protected void serviceStart() throws Exception {
            this.maybeAddSibling();
            super.serviceStart();
        }

        @Override
        protected void serviceStop() throws Exception {
            this.maybeAddSibling();
            super.serviceStop();
        }

        public static void addChildToService(CompositeService parent, Service child) {
            parent.addService(child);
        }
    }

    public static class ServiceManager
    extends CompositeService {
        public void addTestService(CompositeService service) {
            this.addService(service);
        }

        public ServiceManager(String name) {
            super(name);
        }
    }

    public static class CompositeServiceImpl
    extends CompositeService {
        private static int counter = -1;
        private int callSequenceNumber = -1;
        private boolean throwExceptionOnStart;
        private boolean throwExceptionOnStop;

        public static boolean isPolicyToStopOnlyStartedServices() {
            return false;
        }

        public CompositeServiceImpl(int sequenceNumber) {
            super(Integer.toString(sequenceNumber));
        }

        @Override
        protected void serviceInit(Configuration conf) throws Exception {
            this.callSequenceNumber = ++counter;
            super.serviceInit(conf);
        }

        @Override
        protected void serviceStart() throws Exception {
            if (this.throwExceptionOnStart) {
                throw new ServiceTestRuntimeException("Fake service start exception");
            }
            this.callSequenceNumber = ++counter;
            super.serviceStart();
        }

        @Override
        protected void serviceStop() throws Exception {
            this.callSequenceNumber = ++counter;
            if (this.throwExceptionOnStop) {
                throw new ServiceTestRuntimeException("Fake service stop exception");
            }
            super.serviceStop();
        }

        public static int getCounter() {
            return counter;
        }

        public int getCallSequenceNumber() {
            return this.callSequenceNumber;
        }

        public void reset() {
            this.callSequenceNumber = -1;
            counter = -1;
        }

        public static void resetCounter() {
            counter = -1;
        }

        public void setThrowExceptionOnStart(boolean throwExceptionOnStart) {
            this.throwExceptionOnStart = throwExceptionOnStart;
        }

        public void setThrowExceptionOnStop(boolean throwExceptionOnStop) {
            this.throwExceptionOnStop = throwExceptionOnStop;
        }

        @Override
        public String toString() {
            return "Service " + this.getName();
        }
    }

    public static class ServiceTestRuntimeException
    extends RuntimeException {
        public ServiceTestRuntimeException(String message) {
            super(message);
        }
    }

    public static class CompositeServiceAddingAChild
    extends CompositeService {
        Service child;

        public CompositeServiceAddingAChild(Service child) {
            super("CompositeServiceAddingAChild");
            this.child = child;
        }

        @Override
        protected void serviceInit(Configuration conf) throws Exception {
            this.addService(this.child);
            super.serviceInit(conf);
        }
    }
}

