/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.hadoop.shaded.com.google.common.io.Files;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import org.junit.Test;

public class TestZKUtil {
    private static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp") + "/TestZKUtil";
    private static final File TEST_FILE = new File(TEST_ROOT_DIR, "test-file");
    private static final String BOGUS_FILE = new File("/xxxx-this-does-not-exist").getPath();

    @Test
    public void testEmptyACL() {
        List<ACL> result = ZKUtil.parseACLs("");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullACL() {
        List<ACL> result = ZKUtil.parseACLs(null);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testInvalidACLs() {
        TestZKUtil.badAcl("a:b", "ACL 'a:b' not of expected form scheme:id:perm");
        TestZKUtil.badAcl("a", "ACL 'a' not of expected form scheme:id:perm");
        TestZKUtil.badAcl("password:foo:rx", "Invalid permission 'x' in permission string 'rx'");
    }

    private static void badAcl(String acls, String expectedErr) {
        try {
            ZKUtil.parseACLs(acls);
            Assert.fail((String)("Should have failed to parse '" + acls + "'"));
        }
        catch (ZKUtil.BadAclFormatException e) {
            Assert.assertEquals((Object)expectedErr, (Object)e.getMessage());
        }
    }

    @Test
    public void testRemoveSpecificPerms() {
        int perms = 31;
        int remove = 4;
        int newPerms = ZKUtil.removeSpecificPerms(perms, remove);
        Assert.assertEquals((String)"Removal failed", (long)0L, (long)(newPerms & 4));
    }

    @Test
    public void testGoodACLs() {
        List<ACL> result = ZKUtil.parseACLs("sasl:hdfs/host1@MY.DOMAIN:cdrwa, sasl:hdfs/host2@MY.DOMAIN:ca");
        ACL acl0 = result.get(0);
        Assert.assertEquals((long)31L, (long)acl0.getPerms());
        Assert.assertEquals((Object)"sasl", (Object)acl0.getId().getScheme());
        Assert.assertEquals((Object)"hdfs/host1@MY.DOMAIN", (Object)acl0.getId().getId());
        ACL acl1 = result.get(1);
        Assert.assertEquals((long)20L, (long)acl1.getPerms());
        Assert.assertEquals((Object)"sasl", (Object)acl1.getId().getScheme());
        Assert.assertEquals((Object)"hdfs/host2@MY.DOMAIN", (Object)acl1.getId().getId());
    }

    @Test
    public void testEmptyAuth() {
        List<ZKUtil.ZKAuthInfo> result = ZKUtil.parseAuth("");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullAuth() {
        List<ZKUtil.ZKAuthInfo> result = ZKUtil.parseAuth(null);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGoodAuths() {
        List<ZKUtil.ZKAuthInfo> result = ZKUtil.parseAuth("scheme:data,\n   scheme2:user:pass");
        Assert.assertEquals((long)2L, (long)result.size());
        ZKUtil.ZKAuthInfo auth0 = result.get(0);
        Assert.assertEquals((Object)"scheme", (Object)auth0.getScheme());
        Assert.assertEquals((Object)"data", (Object)new String(auth0.getAuth()));
        ZKUtil.ZKAuthInfo auth1 = result.get(1);
        Assert.assertEquals((Object)"scheme2", (Object)auth1.getScheme());
        Assert.assertEquals((Object)"user:pass", (Object)new String(auth1.getAuth()));
    }

    @Test
    public void testConfIndirection() throws IOException {
        Assert.assertNull((Object)ZKUtil.resolveConfIndirection(null));
        Assert.assertEquals((Object)"x", (Object)ZKUtil.resolveConfIndirection("x"));
        TEST_FILE.getParentFile().mkdirs();
        Files.write("hello world", TEST_FILE, Charsets.UTF_8);
        Assert.assertEquals((Object)"hello world", (Object)ZKUtil.resolveConfIndirection("@" + TEST_FILE.getAbsolutePath()));
        try {
            ZKUtil.resolveConfIndirection("@" + BOGUS_FILE);
            Assert.fail((String)"Did not throw for non-existent file reference");
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().startsWith(BOGUS_FILE));
        }
    }
}

