/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.BloomFilterCommonTester;
import org.apache.hadoop.util.bloom.CountingBloomFilter;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.bloom.RetouchedBloomFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestBloomFilters {
    int numInsertions = 1000;
    int bitSize = BloomFilterCommonTester.optimalNumOfBits(this.numInsertions, 0.03);
    int hashFunctionNumber = 5;
    private static final ImmutableMap<Integer, ? extends AbstractCollection<Key>> FALSE_POSITIVE_UNDER_1000 = ImmutableMap.of(0, new AbstractCollection<Key>(){
        final ImmutableList<Key> falsePositive = ImmutableList.of(new Key("99".getBytes()), new Key("963".getBytes()));

        @Override
        public Iterator<Key> iterator() {
            return this.falsePositive.iterator();
        }

        @Override
        public int size() {
            return this.falsePositive.size();
        }
    }, 1, new AbstractCollection<Key>(){
        final ImmutableList<Key> falsePositive = ImmutableList.of(new Key("769".getBytes()), new Key("772".getBytes()), new Key("810".getBytes()), new Key("874".getBytes()));

        @Override
        public Iterator<Key> iterator() {
            return this.falsePositive.iterator();
        }

        @Override
        public int size() {
            return this.falsePositive.size();
        }
    });

    @Test
    public void testDynamicBloomFilter() {
        int hashId = 0;
        DynamicBloomFilter filter = new DynamicBloomFilter(this.bitSize, this.hashFunctionNumber, 0, 3);
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(filter).withTestCases(ImmutableSet.of(BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY)).test();
        Assert.assertNotNull((String)"testDynamicBloomFilter error ", (Object)((Object)filter).toString());
    }

    @Test
    public void testCountingBloomFilter() {
        int hashId = 0;
        CountingBloomFilter filter = new CountingBloomFilter(this.bitSize, this.hashFunctionNumber, hashId);
        Key key = new Key(new byte[]{48, 48});
        filter.add(key);
        Assert.assertTrue((String)"CountingBloomFilter.membership error ", (boolean)filter.membershipTest(key));
        Assert.assertTrue((String)"CountingBloomFilter.approximateCount error", (filter.approximateCount(key) == 1 ? 1 : 0) != 0);
        filter.add(key);
        Assert.assertTrue((String)"CountingBloomFilter.approximateCount error", (filter.approximateCount(key) == 2 ? 1 : 0) != 0);
        filter.delete(key);
        Assert.assertTrue((String)"CountingBloomFilter.membership error ", (boolean)filter.membershipTest(key));
        filter.delete(key);
        Assert.assertFalse((String)"CountingBloomFilter.membership error ", (boolean)filter.membershipTest(key));
        Assert.assertTrue((String)"CountingBloomFilter.approximateCount error", (filter.approximateCount(key) == 0 ? 1 : 0) != 0);
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(filter).withTestCases(ImmutableSet.of(BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY, new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    @Test
    public void testRetouchedBloomFilterSpecific() {
        int numInsertions = 1000;
        int hashFunctionNumber = 5;
        ImmutableSet<Integer> hashes = ImmutableSet.of(Integer.valueOf(1), Integer.valueOf(0));
        for (Integer hashId : hashes) {
            RetouchedBloomFilter filter = new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId);
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)2);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)2);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)1);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)1);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)3);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)3);
            filter.and(new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId));
        }
    }

    private void checkOnAbsentFalsePositive(int hashId, int numInsertions, RetouchedBloomFilter filter, Digits digits, short removeSchema) {
        AbstractCollection<Key> falsePositives = FALSE_POSITIVE_UNDER_1000.get(hashId);
        if (falsePositives == null) {
            Assert.fail((String)String.format("false positives for hash %d not founded", hashId));
        }
        filter.addFalsePositive(falsePositives);
        for (int i = digits.getStart(); i < numInsertions; i += 2) {
            filter.add(new Key(Integer.toString(i).getBytes()));
        }
        for (Key key : falsePositives) {
            filter.selectiveClearing(key, removeSchema);
        }
        for (int i = 1 - digits.getStart(); i < numInsertions; i += 2) {
            Assert.assertFalse((String)(" testRetouchedBloomFilterAddFalsePositive error " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
        }
    }

    @Test
    public void testFiltersWithJenkinsHash() {
        int hashId = 0;
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(new BloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withFilterInstance(new RetouchedBloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withTestCases(ImmutableSet.of(BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY, new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_AND_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    @Test
    public void testFiltersWithMurmurHash() {
        int hashId = 1;
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(new BloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withFilterInstance(new RetouchedBloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withTestCases(ImmutableSet.of(BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY, new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_AND_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    private static enum Digits {
        ODD(1),
        EVEN(0);

        int start;

        private Digits(int start) {
            this.start = start;
        }

        int getStart() {
            return this.start;
        }
    }
}

