/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.FileSystemApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class ApplicationHistoryManagerImpl
extends AbstractService
implements ApplicationHistoryManager {
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryManagerImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private ApplicationHistoryStore historyStore;
    private String serverHttpAddress;

    public ApplicationHistoryManagerImpl() {
        super(ApplicationHistoryManagerImpl.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"ApplicationHistory Init");
        this.historyStore = this.createApplicationHistoryStore(conf);
        this.historyStore.init(conf);
        this.serverHttpAddress = WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getAHSWebAppURLWithoutScheme(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        LOG.info((Object)"Starting ApplicationHistory");
        this.historyStore.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        LOG.info((Object)"Stopping ApplicationHistory");
        this.historyStore.stop();
        super.serviceStop();
    }

    protected ApplicationHistoryStore createApplicationHistoryStore(Configuration conf) {
        return ReflectionUtils.newInstance(conf.getClass("yarn.timeline-service.generic-application-history.store-class", FileSystemApplicationHistoryStore.class, ApplicationHistoryStore.class), conf);
    }

    @Override
    public ContainerReport getAMContainer(ApplicationAttemptId appAttemptId) throws IOException {
        ApplicationReport app = this.getApplication(appAttemptId.getApplicationId());
        return this.convertToContainerReport(this.historyStore.getAMContainer(appAttemptId), app == null ? null : app.getUser());
    }

    @Override
    public Map<ApplicationId, ApplicationReport> getAllApplications() throws IOException {
        Map<ApplicationId, ApplicationHistoryData> histData = this.historyStore.getAllApplications();
        HashMap<ApplicationId, ApplicationReport> applicationsReport = new HashMap<ApplicationId, ApplicationReport>();
        for (Map.Entry<ApplicationId, ApplicationHistoryData> entry : histData.entrySet()) {
            applicationsReport.put(entry.getKey(), this.convertToApplicationReport(entry.getValue()));
        }
        return applicationsReport;
    }

    @Override
    public ApplicationReport getApplication(ApplicationId appId) throws IOException {
        return this.convertToApplicationReport(this.historyStore.getApplication(appId));
    }

    private ApplicationReport convertToApplicationReport(ApplicationHistoryData appHistory) throws IOException {
        ApplicationAttemptId currentApplicationAttemptId = null;
        String trackingUrl = UNAVAILABLE;
        String host = UNAVAILABLE;
        int rpcPort = -1;
        ApplicationAttemptHistoryData lastAttempt = this.getLastAttempt(appHistory.getApplicationId());
        if (lastAttempt != null) {
            currentApplicationAttemptId = lastAttempt.getApplicationAttemptId();
            trackingUrl = lastAttempt.getTrackingURL();
            host = lastAttempt.getHost();
            rpcPort = lastAttempt.getRPCPort();
        }
        return ApplicationReport.newInstance(appHistory.getApplicationId(), currentApplicationAttemptId, appHistory.getUser(), appHistory.getQueue(), appHistory.getApplicationName(), host, rpcPort, null, appHistory.getYarnApplicationState(), appHistory.getDiagnosticsInfo(), trackingUrl, appHistory.getStartTime(), appHistory.getFinishTime(), appHistory.getFinalApplicationStatus(), null, "", 100.0f, appHistory.getApplicationType(), null);
    }

    private ApplicationAttemptHistoryData getLastAttempt(ApplicationId appId) throws IOException {
        Map<ApplicationAttemptId, ApplicationAttemptHistoryData> attempts = this.historyStore.getApplicationAttempts(appId);
        ApplicationAttemptId prevMaxAttemptId = null;
        for (ApplicationAttemptId attemptId : attempts.keySet()) {
            if (prevMaxAttemptId == null) {
                prevMaxAttemptId = attemptId;
                continue;
            }
            if (prevMaxAttemptId.getAttemptId() >= attemptId.getAttemptId()) continue;
            prevMaxAttemptId = attemptId;
        }
        return attempts.get(prevMaxAttemptId);
    }

    private ApplicationAttemptReport convertToApplicationAttemptReport(ApplicationAttemptHistoryData appAttemptHistory) {
        return ApplicationAttemptReport.newInstance(appAttemptHistory.getApplicationAttemptId(), appAttemptHistory.getHost(), appAttemptHistory.getRPCPort(), appAttemptHistory.getTrackingURL(), appAttemptHistory.getDiagnosticsInfo(), appAttemptHistory.getYarnApplicationAttemptState(), appAttemptHistory.getMasterContainerId());
    }

    @Override
    public ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId) throws IOException {
        return this.convertToApplicationAttemptReport(this.historyStore.getApplicationAttempt(appAttemptId));
    }

    @Override
    public Map<ApplicationAttemptId, ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws IOException {
        Map<ApplicationAttemptId, ApplicationAttemptHistoryData> histData = this.historyStore.getApplicationAttempts(appId);
        HashMap<ApplicationAttemptId, ApplicationAttemptReport> applicationAttemptsReport = new HashMap<ApplicationAttemptId, ApplicationAttemptReport>();
        for (Map.Entry<ApplicationAttemptId, ApplicationAttemptHistoryData> entry : histData.entrySet()) {
            applicationAttemptsReport.put(entry.getKey(), this.convertToApplicationAttemptReport(entry.getValue()));
        }
        return applicationAttemptsReport;
    }

    @Override
    public ContainerReport getContainer(ContainerId containerId) throws IOException {
        ApplicationReport app = this.getApplication(containerId.getApplicationAttemptId().getApplicationId());
        return this.convertToContainerReport(this.historyStore.getContainer(containerId), app == null ? null : app.getUser());
    }

    private ContainerReport convertToContainerReport(ContainerHistoryData containerHistory, String user) {
        String logUrl = WebAppUtils.getAggregatedLogURL(this.serverHttpAddress, containerHistory.getAssignedNode().toString(), containerHistory.getContainerId().toString(), containerHistory.getContainerId().toString(), user);
        return ContainerReport.newInstance(containerHistory.getContainerId(), containerHistory.getAllocatedResource(), containerHistory.getAssignedNode(), containerHistory.getPriority(), containerHistory.getStartTime(), containerHistory.getFinishTime(), containerHistory.getDiagnosticsInfo(), logUrl, containerHistory.getContainerExitStatus(), containerHistory.getContainerState());
    }

    @Override
    public Map<ContainerId, ContainerReport> getContainers(ApplicationAttemptId appAttemptId) throws IOException {
        ApplicationReport app = this.getApplication(appAttemptId.getApplicationId());
        Map<ContainerId, ContainerHistoryData> histData = this.historyStore.getContainers(appAttemptId);
        HashMap<ContainerId, ContainerReport> containersReport = new HashMap<ContainerId, ContainerReport>();
        for (Map.Entry<ContainerId, ContainerHistoryData> entry : histData.entrySet()) {
            containersReport.put(entry.getKey(), this.convertToContainerReport(entry.getValue(), app == null ? null : app.getUser()));
        }
        return containersReport;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ApplicationHistoryStore getHistoryStore() {
        return this.historyStore;
    }
}

