/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebApp;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class ApplicationHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryServer.class);
    ApplicationHistoryClientService ahsClientService;
    ApplicationHistoryManager historyManager;
    TimelineStore timelineStore;
    private WebApp webApp;

    public ApplicationHistoryServer() {
        super(ApplicationHistoryServer.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.historyManager = this.createApplicationHistory();
        this.ahsClientService = this.createApplicationHistoryClientService(this.historyManager);
        this.addService(this.ahsClientService);
        this.addService((Service)((Object)this.historyManager));
        this.timelineStore = this.createTimelineStore(conf);
        this.addIfService(this.timelineStore);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        DefaultMetricsSystem.initialize("ApplicationHistoryServer");
        JvmMetrics.initSingleton("ApplicationHistoryServer", null);
        this.startWebApp();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ApplicationHistoryClientService getClientService() {
        return this.ahsClientService;
    }

    protected ApplicationHistoryClientService createApplicationHistoryClientService(ApplicationHistoryManager historyManager) {
        return new ApplicationHistoryClientService(historyManager);
    }

    protected ApplicationHistoryManager createApplicationHistory() {
        return new ApplicationHistoryManagerImpl();
    }

    protected ApplicationHistoryManager getApplicationHistory() {
        return this.historyManager;
    }

    static ApplicationHistoryServer launchAppHistoryServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ApplicationHistoryServer.class, args, LOG);
        ApplicationHistoryServer appHistoryServer = null;
        try {
            appHistoryServer = new ApplicationHistoryServer();
            ShutdownHookManager.get().addShutdownHook(new CompositeService.CompositeServiceShutdownHook(appHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration();
            appHistoryServer.init(conf);
            appHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ApplicationHistoryServer", t);
            ExitUtil.terminate(-1, "Error starting ApplicationHistoryServer");
        }
        return appHistoryServer;
    }

    public static void main(String[] args) {
        ApplicationHistoryServer.launchAppHistoryServer(args);
    }

    protected ApplicationHistoryManager createApplicationHistoryManager(Configuration conf) {
        return new ApplicationHistoryManagerImpl();
    }

    protected TimelineStore createTimelineStore(Configuration conf) {
        return ReflectionUtils.newInstance(conf.getClass("yarn.timeline-service.store-class", LeveldbTimelineStore.class, TimelineStore.class), conf);
    }

    protected void startWebApp() {
        String bindAddress = WebAppUtils.getAHSWebAppURLWithoutScheme(this.getConfig());
        LOG.info((Object)("Instantiating AHSWebApp at " + bindAddress));
        try {
            this.webApp = WebApps.$for("applicationhistory", ApplicationHistoryClientService.class, this.ahsClientService, "ws").with(this.getConfig()).withHttpSpnegoPrincipalKey("yarn.timeline-service.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.timeline-service.webapp.spnego-keytab-file").at(bindAddress).start(new AHSWebApp(this.historyManager, this.timelineStore));
        }
        catch (Exception e) {
            String msg = "AHSWebApp failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, e);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelineStore getTimelineStore() {
        return this.timelineStore;
    }
}

