/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;

public class DeletionService
extends AbstractService {
    static final Log LOG = LogFactory.getLog(DeletionService.class);
    private int debugDelay;
    private final ContainerExecutor exec;
    private ScheduledThreadPoolExecutor sched;
    private static final FileContext lfs = DeletionService.getLfs();

    static final FileContext getLfs() {
        try {
            return FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public DeletionService(ContainerExecutor exec) {
        super(DeletionService.class.getName());
        this.exec = exec;
        this.debugDelay = 0;
    }

    public void delete(String user, Path subDir, Path ... baseDirs) {
        if (this.debugDelay != -1) {
            if (baseDirs == null || baseDirs.length == 0) {
                this.sched.schedule(new FileDeletionTask(this, user, subDir, null), (long)this.debugDelay, TimeUnit.SECONDS);
            } else {
                this.sched.schedule(new FileDeletionTask(this, user, subDir, Arrays.asList(baseDirs)), (long)this.debugDelay, TimeUnit.SECONDS);
            }
        }
    }

    public void scheduleFileDeletionTask(FileDeletionTask fileDeletionTask) {
        if (this.debugDelay != -1) {
            this.sched.schedule(fileDeletionTask, (long)this.debugDelay, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DeletionService #%d").build();
        if (conf != null) {
            this.sched = new ScheduledThreadPoolExecutor(conf.getInt("yarn.nodemanager.delete.thread-count", 4), tf);
            this.debugDelay = conf.getInt("yarn.nodemanager.delete.debug-delay-sec", 0);
        } else {
            this.sched = new ScheduledThreadPoolExecutor(4, tf);
        }
        this.sched.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sched.setKeepAliveTime(60L, TimeUnit.SECONDS);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.sched != null) {
            this.sched.shutdown();
            boolean terminated = false;
            try {
                terminated = this.sched.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!terminated) {
                this.sched.shutdownNow();
            }
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public boolean isTerminated() {
        return this.getServiceState() == Service.STATE.STOPPED && this.sched.isTerminated();
    }

    public FileDeletionTask createFileDeletionTask(String user, Path subDir, Path[] baseDirs) {
        return new FileDeletionTask(this, user, subDir, Arrays.asList(baseDirs));
    }

    public static class FileDeletionTask
    implements Runnable {
        private final String user;
        private final Path subDir;
        private final List<Path> baseDirs;
        private final AtomicInteger numberOfPendingPredecessorTasks;
        private final Set<FileDeletionTask> successorTaskSet;
        private final DeletionService delService;
        private boolean success;

        private FileDeletionTask(DeletionService delService, String user, Path subDir, List<Path> baseDirs) {
            this.delService = delService;
            this.user = user;
            this.subDir = subDir;
            this.baseDirs = baseDirs;
            this.successorTaskSet = new HashSet<FileDeletionTask>();
            this.numberOfPendingPredecessorTasks = new AtomicInteger(0);
            this.success = true;
        }

        public int incrementAndGetPendingPredecessorTasks() {
            return this.numberOfPendingPredecessorTasks.incrementAndGet();
        }

        public int decrementAndGetPendingPredecessorTasks() {
            return this.numberOfPendingPredecessorTasks.decrementAndGet();
        }

        @VisibleForTesting
        public String getUser() {
            return this.user;
        }

        @VisibleForTesting
        public Path getSubDir() {
            return this.subDir;
        }

        @VisibleForTesting
        public List<Path> getBaseDirs() {
            return this.baseDirs;
        }

        public synchronized void setSuccess(boolean success) {
            this.success = success;
        }

        public synchronized boolean getSucess() {
            return this.success;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this);
            }
            boolean error = false;
            if (null == this.user) {
                if (this.baseDirs == null || this.baseDirs.size() == 0) {
                    LOG.debug((Object)("NM deleting absolute path : " + this.subDir));
                    try {
                        lfs.delete(this.subDir, true);
                    }
                    catch (IOException e) {
                        error = true;
                        LOG.warn((Object)("Failed to delete " + this.subDir));
                    }
                } else {
                    for (Path baseDir : this.baseDirs) {
                        Path del = this.subDir == null ? baseDir : new Path(baseDir, this.subDir);
                        LOG.debug((Object)("NM deleting path : " + del));
                        try {
                            lfs.delete(del, true);
                        }
                        catch (IOException e) {
                            error = true;
                            LOG.warn((Object)("Failed to delete " + this.subDir));
                        }
                    }
                }
            } else {
                try {
                    LOG.debug((Object)("Deleting path: [" + this.subDir + "] as user: [" + this.user + "]"));
                    if (this.baseDirs == null || this.baseDirs.size() == 0) {
                        this.delService.exec.deleteAsUser(this.user, this.subDir, null);
                    }
                    this.delService.exec.deleteAsUser(this.user, this.subDir, this.baseDirs.toArray(new Path[0]));
                }
                catch (IOException e) {
                    error = true;
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
                catch (InterruptedException e) {
                    error = true;
                    LOG.warn((Object)("Failed to delete as user " + this.user), (Throwable)e);
                }
            }
            if (error) {
                this.setSuccess(!error);
            }
            this.fileDeletionTaskFinished();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("\nFileDeletionTask : ");
            sb.append("  user : ").append(this.user);
            sb.append("  subDir : ").append(this.subDir == null ? "null" : this.subDir.toString());
            sb.append("  baseDir : ");
            if (this.baseDirs == null || this.baseDirs.size() == 0) {
                sb.append("null");
            } else {
                for (Path baseDir : this.baseDirs) {
                    sb.append(baseDir.toString()).append(',');
                }
            }
            return sb.toString();
        }

        public synchronized void addFileDeletionTaskDependency(FileDeletionTask successorTask) {
            if (this.successorTaskSet.add(successorTask)) {
                successorTask.incrementAndGetPendingPredecessorTasks();
            }
        }

        private synchronized void fileDeletionTaskFinished() {
            for (FileDeletionTask successorTask : this.successorTaskSet) {
                int count;
                if (!this.success) {
                    successorTask.setSuccess(this.success);
                }
                if ((count = successorTask.decrementAndGetPendingPredecessorTasks()) != 0) continue;
                if (successorTask.getSucess()) {
                    successorTask.delService.scheduleFileDeletionTask(successorTask);
                    continue;
                }
                successorTask.fileDeletionTaskFinished();
            }
        }
    }
}

