/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.util.LCEResourcesHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

public class CgroupsLCEResourcesHandler
implements LCEResourcesHandler {
    static final Log LOG = LogFactory.getLog(CgroupsLCEResourcesHandler.class);
    private Configuration conf;
    private String cgroupPrefix;
    private boolean cgroupMount;
    private String cgroupMountPath;
    private boolean cpuWeightEnabled = true;
    private final String MTAB_FILE = "/proc/mounts";
    private final String CGROUPS_FSTYPE = "cgroup";
    private final String CONTROLLER_CPU = "cpu";
    private final int CPU_DEFAULT_WEIGHT = 1024;
    private final Map<String, String> controllerPaths = new HashMap<String, String>();
    private long deleteCgroupTimeout;
    Clock clock = new SystemClock();
    private static final Pattern MTAB_FILE_FORMAT = Pattern.compile("^[^\\s]+\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s[^\\s]+\\s[^\\s]+$");

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    void initConfig() throws IOException {
        int len;
        this.cgroupPrefix = this.conf.get("yarn.nodemanager.linux-container-executor.cgroups.hierarchy", "/hadoop-yarn");
        this.cgroupMount = this.conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.mount", false);
        this.cgroupMountPath = this.conf.get("yarn.nodemanager.linux-container-executor.cgroups.mount-path", null);
        this.deleteCgroupTimeout = this.conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms", 1000L);
        if (this.cgroupPrefix.charAt(0) == '/') {
            this.cgroupPrefix = this.cgroupPrefix.substring(1);
        }
        if (this.cgroupPrefix.charAt((len = this.cgroupPrefix.length()) - 1) == '/') {
            this.cgroupPrefix = this.cgroupPrefix.substring(0, len - 1);
        }
    }

    @Override
    public void init(LinuxContainerExecutor lce) throws IOException {
        this.initConfig();
        if (this.cgroupMount && this.cgroupMountPath != null) {
            ArrayList<String> cgroupKVs = new ArrayList<String>();
            cgroupKVs.add("cpu=" + this.cgroupMountPath + "/" + "cpu");
            lce.mountCgroups(cgroupKVs, this.cgroupPrefix);
        }
        this.initializeControllerPaths();
    }

    boolean isCpuWeightEnabled() {
        return this.cpuWeightEnabled;
    }

    private String pathForCgroup(String controller, String groupName) {
        String controllerPath = this.controllerPaths.get(controller);
        return controllerPath + "/" + this.cgroupPrefix + "/" + groupName;
    }

    private void createCgroup(String controller, String groupName) throws IOException {
        String path = this.pathForCgroup(controller, groupName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createCgroup: " + path));
        }
        if (!new File(path).mkdir()) {
            throw new IOException("Failed to create cgroup at " + path);
        }
    }

    private void updateCgroup(String controller, String groupName, String param, String value) throws IOException {
        OutputStreamWriter f = null;
        String path = this.pathForCgroup(controller, groupName);
        param = controller + "." + param;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateCgroup: " + path + ": " + param + "=" + value));
        }
        try {
            f = new FileWriter(path + "/" + param, false);
            f.write(value);
        }
        catch (IOException e) {
            throw new IOException("Unable to set " + param + "=" + value + " for cgroup at: " + path, e);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Unable to close cgroup file: " + path), (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    boolean deleteCgroup(String cgroupPath) {
        boolean deleted;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteCgroup: " + cgroupPath));
        }
        long start = this.clock.getTime();
        do {
            if (deleted = new File(cgroupPath).delete()) continue;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        } while (!deleted && this.clock.getTime() - start < this.deleteCgroupTimeout);
        if (!deleted) {
            LOG.warn((Object)("Unable to delete cgroup at: " + cgroupPath + ", tried to delete for " + this.deleteCgroupTimeout + "ms"));
        }
        return deleted;
    }

    private void setupLimits(ContainerId containerId, Resource containerResource) throws IOException {
        String containerName = containerId.toString();
        if (this.isCpuWeightEnabled()) {
            this.createCgroup("cpu", containerName);
            int cpuShares = 1024 * containerResource.getVirtualCores();
            this.updateCgroup("cpu", containerName, "shares", String.valueOf(cpuShares));
        }
    }

    private void clearLimits(ContainerId containerId) {
        if (this.isCpuWeightEnabled()) {
            this.deleteCgroup(this.pathForCgroup("cpu", containerId.toString()));
        }
    }

    @Override
    public void preExecute(ContainerId containerId, Resource containerResource) throws IOException {
        this.setupLimits(containerId, containerResource);
    }

    @Override
    public void postExecute(ContainerId containerId) {
        this.clearLimits(containerId);
    }

    @Override
    public String getResourcesOption(ContainerId containerId) {
        String containerName = containerId.toString();
        StringBuilder sb = new StringBuilder("cgroups=");
        if (this.isCpuWeightEnabled()) {
            sb.append(this.pathForCgroup("cpu", containerName) + "/tasks");
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Map<String, List<String>> parseMtab() throws IOException {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(new File("/proc/mounts")));
            String str = in.readLine();
            while (str != null) {
                Matcher m = MTAB_FILE_FORMAT.matcher(str);
                boolean mat = m.find();
                if (mat) {
                    String path = m.group(1);
                    String type = m.group(2);
                    String options = m.group(3);
                    if (type.equals("cgroup")) {
                        List<String> value = Arrays.asList(options.split(","));
                        ret.put(path, value);
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException e) {
            throw new IOException("Error while reading /proc/mounts", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e2) {
                LOG.warn((Object)"Error closing the stream: /proc/mounts", (Throwable)e2);
            }
        }
        return ret;
    }

    private String findControllerInMtab(String controller, Map<String, List<String>> entries) {
        for (Map.Entry<String, List<String>> e : entries.entrySet()) {
            if (!e.getValue().contains(controller)) continue;
            return e.getKey();
        }
        return null;
    }

    private void initializeControllerPaths() throws IOException {
        Map<String, List<String>> parsedMtab = this.parseMtab();
        String controllerPath = this.findControllerInMtab("cpu", parsedMtab);
        if (controllerPath != null) {
            File f = new File(controllerPath + "/" + this.cgroupPrefix);
            if (!FileUtil.canWrite(f)) {
                throw new IOException("Not able to enforce cpu weights; cannot write to cgroup at: " + controllerPath);
            }
        } else {
            throw new IOException("Not able to enforce cpu weights; cannot find cgroup for cpu controller in /proc/mounts");
        }
        this.controllerPaths.put("cpu", controllerPath);
    }
}

