/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ContainerPage
extends NMView
implements YarnWebParams {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.setTitle("Container " + this.$("container.id"));
        this.set(JQueryUI.initID("ui.accordion", "nav"), "{autoHeight:false, active:0}");
    }

    @Override
    protected Class<? extends SubView> content() {
        return ContainerBlock.class;
    }

    public static class ContainerBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public ContainerBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            ContainerId containerID;
            try {
                containerID = ConverterUtils.toContainerId(this.$("container.id"));
            }
            catch (IllegalArgumentException e) {
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Invalid containerId " + this.$("container.id")})))._();
                return;
            }
            HamletSpec.DIV div = html.div("#content");
            Container container = (Container)this.nmContext.getContainers().get(containerID);
            if (container == null) {
                ((HamletImpl.EImp)((Object)((Hamlet.DIV)div).h1("Unknown Container. Container might have completed, please go back to the previous page and retry.")))._();
                return;
            }
            ContainerInfo info = new ContainerInfo(this.nmContext, container);
            this.info("Container information")._("ContainerID", info.getId())._("ContainerState", info.getState())._("ExitStatus", info.getExitStatus())._("Diagnostics", info.getDiagnostics())._("User", info.getUser())._("TotalMemoryNeeded", info.getMemoryNeeded())._("logs", info.getShortLogLink(), "Link to logs");
            html._(InfoBlock.class);
        }
    }
}

