/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class NodePage
extends NMView {
    private static final long BYTES_IN_MB = 0x100000L;

    @Override
    protected void commonPreHead(Hamlet.HTML<HtmlPage._> html) {
        super.commonPreHead(html);
        this.set(JQueryUI.initID("ui.accordion", "nav"), "{autoHeight:false, active:1}");
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodeBlock.class;
    }

    public static class NodeBlock
    extends HtmlBlock {
        private final Context context;
        private final ResourceView resourceView;

        @Inject
        public NodeBlock(Context context, ResourceView resourceView) {
            this.context = context;
            this.resourceView = resourceView;
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            NodeInfo info = new NodeInfo(this.context, this.resourceView);
            this.info("NodeManager information")._("Total Vmem allocated for Containers", StringUtils.byteDesc(info.getTotalVmemAllocated() * 0x100000L))._("Vmem enforcement enabled", info.isVmemCheckEnabled())._("Total Pmem allocated for Container", StringUtils.byteDesc(info.getTotalPmemAllocated() * 0x100000L))._("Pmem enforcement enabled", info.isVmemCheckEnabled())._("NodeHealthyStatus", info.getHealthStatus())._("LastNodeHealthTime", new Date(info.getLastNodeUpdateTime()))._("NodeHealthReport", info.getHealthReport())._("Node Manager Version:", info.getNMBuildVersion() + " on " + info.getNMVersionBuiltOn())._("Hadoop Version:", info.getHadoopBuildVersion() + " on " + info.getHadoopVersionBuiltOn());
            html._(InfoBlock.class);
        }
    }
}

