/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.RMStateVersionPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(FileSystemRMStateStore.class);
    protected static final String ROOT_DIR_NAME = "FSRMStateRoot";
    protected static final RMStateVersion CURRENT_VERSION_INFO = RMStateVersion.newInstance(1, 0);
    protected FileSystem fs;
    private Path rootDirPath;
    @InterfaceAudience.Private
    @VisibleForTesting
    Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private Path dtSequenceNumberPath = null;
    @VisibleForTesting
    Path fsWorkingPath;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, "RMDTSecretManagerRoot");
        this.rmAppRoot = new Path(this.rootDirPath, "RMAppRoot");
    }

    @Override
    protected synchronized void startInternal() throws Exception {
        Configuration conf = new Configuration(this.getConfig());
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        String retryPolicy = conf.get("yarn.resourcemanager.fs.state-store.retry-policy-spec", "2000, 500");
        conf.set("dfs.client.retry.policy.spec", retryPolicy);
        this.fs = this.fsWorkingPath.getFileSystem(conf);
        this.fs.mkdirs(this.rmDTSecretManagerRoot);
        this.fs.mkdirs(this.rmAppRoot);
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.fs.close();
    }

    @Override
    protected RMStateVersion getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized RMStateVersion loadVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        if (this.fs.exists(versionNodePath)) {
            FileStatus status = this.fs.getFileStatus(versionNodePath);
            byte[] data = this.readFile(versionNodePath, status.getLen());
            RMStateVersionPBImpl version = new RMStateVersionPBImpl(YarnServerResourceManagerServiceProtos.RMStateVersionProto.parseFrom(data));
            return version;
        }
        return null;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        byte[] data = ((RMStateVersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.fs.exists(versionNodePath)) {
            this.updateFile(versionNodePath, data);
        } else {
            this.writeFile(versionNodePath, data);
        }
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        return rmState;
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<RMStateStore.ApplicationAttemptState> attempts = new ArrayList<RMStateStore.ApplicationAttemptState>();
            for (FileStatus appDir : this.fs.listStatus(this.rmAppRoot)) {
                this.checkAndResumeUpdateOperation(appDir.getPath());
                for (FileStatus childNodeStatus : this.fs.listStatus(appDir.getPath())) {
                    assert (childNodeStatus.isFile());
                    String childNodeName = childNodeStatus.getPath().getName();
                    if (this.checkAndRemovePartialRecord(childNodeStatus.getPath())) continue;
                    byte[] childData = this.readFile(childNodeStatus.getPath(), childNodeStatus.getLen());
                    if (childNodeName.startsWith("application_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application from node: " + childNodeName));
                        }
                        ApplicationId appId = ConverterUtils.toApplicationId(childNodeName);
                        ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.parseFrom(childData));
                        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser(), appStateData.getState(), appStateData.getDiagnostics(), appStateData.getFinishTime());
                        assert (appId.equals(appState.context.getApplicationId()));
                        rmState.appState.put(appId, appState);
                        continue;
                    }
                    if (childNodeName.startsWith("appattempt_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application attempt from node: " + childNodeName));
                        }
                        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId(childNodeName);
                        ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.parseFrom(childData));
                        Credentials credentials = null;
                        if (attemptStateData.getAppAttemptTokens() != null) {
                            credentials = new Credentials();
                            DataInputByteBuffer dibb = new DataInputByteBuffer();
                            dibb.reset(attemptStateData.getAppAttemptTokens());
                            credentials.readTokenStorageStream(dibb);
                        }
                        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime(), attemptStateData.getState(), attemptStateData.getFinalTrackingUrl(), attemptStateData.getDiagnostics(), attemptStateData.getFinalApplicationStatus());
                        assert (attemptId.equals(attemptState.getAttemptId()));
                        attempts.add(attemptState);
                        continue;
                    }
                    LOG.info((Object)("Unknown child node with name: " + childNodeName));
                }
            }
            for (RMStateStore.ApplicationAttemptState attemptState : attempts) {
                ApplicationId appId = attemptState.getAttemptId().getApplicationId();
                RMStateStore.ApplicationState appState = rmState.appState.get(appId);
                assert (appState != null);
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            }
            LOG.info((Object)"Done Loading applications from FS state store");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private boolean checkAndRemovePartialRecord(Path record) throws IOException {
        if (record.getName().endsWith(".tmp")) {
            LOG.error((Object)("incomplete rm state store entry found :" + record));
            this.fs.delete(record, false);
            return true;
        }
        return false;
    }

    private void checkAndResumeUpdateOperation(Path path) throws Exception {
        FileStatus[] newChildNodes;
        for (FileStatus newChildNodeStatus : newChildNodes = this.fs.listStatus(path, new PathFilter(){

            @Override
            public boolean accept(Path path) {
                return path.getName().endsWith(".new");
            }
        })) {
            assert (newChildNodeStatus.isFile());
            String newChildNodeName = newChildNodeStatus.getPath().getName();
            String childNodeName = newChildNodeName.substring(0, newChildNodeName.length() - ".new".length());
            Path childNodePath = new Path(newChildNodeStatus.getPath().getParent(), childNodeName);
            this.replaceFile(newChildNodeStatus.getPath(), childNodePath);
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        this.checkAndResumeUpdateOperation(this.rmDTSecretManagerRoot);
        for (FileStatus childNodeStatus : childNodes = this.fs.listStatus(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (this.checkAndRemovePartialRecord(childNodeStatus.getPath())) continue;
            if (childNodeName.startsWith("RMDTSequenceNumber_")) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFile(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            if (childNodeName.startsWith("DelegationKey_")) {
                DelegationKey key = new DelegationKey();
                key.readFields(fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
            } else if (childNodeName.startsWith("RMDelegationToken_")) {
                RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
                identifier.readFields(fsIn);
                long renewDate = fsIn.readLong();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
            } else {
                LOG.warn((Object)"Unknown file for recovering RMDelegationTokenSecretManager");
            }
            fsIn.close();
        }
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        String appIdStr = appId.toString();
        Path appDirPath = this.getAppDir(this.rmAppRoot, appIdStr);
        this.fs.mkdirs(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appIdStr);
        LOG.info((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        String appIdStr = appId.toString();
        Path appDirPath = this.getAppDir(this.rmAppRoot, appIdStr);
        Path nodeCreatePath = this.getNodePath(appDirPath, appIdStr);
        LOG.info((Object)("Updating info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Updating info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        Path nodeRemovePath = this.getAppDir(this.rmAppRoot, appId);
        LOG.info((Object)("Removing info for app: " + appId + " at: " + nodeRemovePath));
        this.deleteFile(nodeRemovePath);
    }

    @Override
    public synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier identifier, Long renewDate, int latestSequenceNumber) throws Exception {
        this.storeOrUpdateRMDelegationTokenAndSequenceNumberState(identifier, renewDate, latestSequenceNumber, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        LOG.info((Object)("Removing RMDelegationToken_" + identifier.getSequenceNumber()));
        this.deleteFile(nodeCreatePath);
    }

    @Override
    protected void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        this.storeOrUpdateRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber, true);
    }

    private void storeOrUpdateRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier identifier, Long renewDate, int latestSequenceNumber, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        identifier.write(fsOut);
        fsOut.writeLong(renewDate);
        if (isUpdate) {
            LOG.info((Object)("Updating RMDelegationToken_" + identifier.getSequenceNumber()));
            this.updateFile(nodeCreatePath, os.toByteArray());
        } else {
            LOG.info((Object)("Storing RMDelegationToken_" + identifier.getSequenceNumber()));
            this.writeFile(nodeCreatePath, os.toByteArray());
        }
        fsOut.close();
        Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDTSequenceNumber_" + latestSequenceNumber);
        LOG.info((Object)("Storing RMDTSequenceNumber_" + latestSequenceNumber));
        if (this.dtSequenceNumberPath == null) {
            if (!this.createFile(latestSequenceNumberPath)) {
                throw new Exception("Failed to create " + latestSequenceNumberPath);
            }
        } else if (!this.renameFile(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
            throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
        }
        this.dtSequenceNumberPath = latestSequenceNumberPath;
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        LOG.info((Object)("Storing RMDelegationKey_" + masterKey.getKeyId()));
        masterKey.write(fsOut);
        this.writeFile(nodeCreatePath, os.toByteArray());
        fsOut.close();
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        LOG.info((Object)("Removing RMDelegationKey_" + masterKey.getKeyId()));
        this.deleteFile(nodeCreatePath);
    }

    private Path getAppDir(Path root, String appId) {
        return this.getNodePath(root, appId);
    }

    private void deleteFile(Path deletePath) throws Exception {
        if (!this.fs.delete(deletePath, true)) {
            throw new Exception("Failed to delete " + deletePath);
        }
    }

    private byte[] readFile(Path inputPath, long len) throws Exception {
        FSDataInputStream fsIn = this.fs.open(inputPath);
        byte[] data = new byte[(int)len];
        fsIn.readFully(data);
        fsIn.close();
        return data;
    }

    private void writeFile(Path outputPath, byte[] data) throws Exception {
        Path tempPath = new Path(outputPath.getParent(), outputPath.getName() + ".tmp");
        FSDataOutputStream fsOut = null;
        fsOut = this.fs.create(tempPath, true);
        fsOut.write(data);
        fsOut.close();
        this.fs.rename(tempPath, outputPath);
    }

    protected void updateFile(Path outputPath, byte[] data) throws Exception {
        Path newPath = new Path(outputPath.getParent(), outputPath.getName() + ".new");
        this.writeFile(newPath, data);
        this.replaceFile(newPath, outputPath);
    }

    protected void replaceFile(Path srcPath, Path dstPath) throws Exception {
        if (this.fs.exists(dstPath)) {
            this.deleteFile(dstPath);
        } else {
            LOG.info((Object)("File doesn't exist. Skip deleting the file " + dstPath));
        }
        this.fs.rename(srcPath, dstPath);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }
}

