/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMoveEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppStartAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMAppImpl
implements RMApp,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private final ApplicationId applicationId;
    private final RMContext rmContext;
    private final Configuration conf;
    private final String user;
    private final String name;
    private final ApplicationSubmissionContext submissionContext;
    private final Dispatcher dispatcher;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final StringBuilder diagnostics = new StringBuilder();
    private final int maxAppAttempts;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Map<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap<ApplicationAttemptId, RMAppAttempt>();
    private final long submitTime;
    private final Set<RMNode> updatedNodes = new HashSet<RMNode>();
    private final String applicationType;
    private final Set<String> applicationTags;
    private long startTime;
    private long finishTime = 0L;
    private long storedFinishTime = 0L;
    private RMAppAttempt currentAttempt;
    private String queue;
    private EventHandler handler;
    private static final AppFinishedTransition FINISHED_TRANSITION = new AppFinishedTransition();
    private RMAppState stateBeforeKilling;
    private RMAppState stateBeforeFinalSaving;
    private RMAppEvent eventCausingFinalSaving;
    private RMAppState targetedFinalState;
    private RMAppState recoveredFinalState;
    Object transitionTodo;
    private static final StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent> stateMachineFactory = new StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent>(RMAppState.NEW).addTransition(RMAppState.NEW, RMAppState.NEW, RMAppEventType.NODE_UPDATE, new RMAppNodeUpdateTransition()).addTransition(RMAppState.NEW, RMAppState.NEW_SAVING, RMAppEventType.START, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppNewlySavingTransition()).addTransition(RMAppState.NEW, EnumSet.of(RMAppState.SUBMITTED, new RMAppState[]{RMAppState.ACCEPTED, RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINAL_SAVING}), RMAppEventType.RECOVER, new RMAppRecoveredTransition()).addTransition(RMAppState.NEW, RMAppState.KILLED, RMAppEventType.KILL, (SingleArcTransition<RMAppImpl, RMAppEvent>)new AppKilledTransition()).addTransition(RMAppState.NEW, RMAppState.FAILED, RMAppEventType.APP_REJECTED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new AppRejectedTransition()).addTransition(RMAppState.NEW_SAVING, RMAppState.NEW_SAVING, RMAppEventType.NODE_UPDATE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppNodeUpdateTransition()).addTransition(RMAppState.NEW_SAVING, RMAppState.SUBMITTED, RMAppEventType.APP_NEW_SAVED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new AddApplicationToSchedulerTransition()).addTransition(RMAppState.NEW_SAVING, RMAppState.FINAL_SAVING, RMAppEventType.KILL, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition(RMAppState.NEW_SAVING, RMAppState.FINAL_SAVING, RMAppEventType.APP_REJECTED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AppRejectedTransition(), RMAppState.FAILED)).addTransition(RMAppState.SUBMITTED, RMAppState.SUBMITTED, RMAppEventType.NODE_UPDATE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppNodeUpdateTransition()).addTransition(RMAppState.SUBMITTED, RMAppState.SUBMITTED, RMAppEventType.MOVE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppMoveTransition()).addTransition(RMAppState.SUBMITTED, RMAppState.FINAL_SAVING, RMAppEventType.APP_REJECTED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AppRejectedTransition(), RMAppState.FAILED)).addTransition(RMAppState.SUBMITTED, RMAppState.ACCEPTED, RMAppEventType.APP_ACCEPTED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new StartAppAttemptTransition()).addTransition(RMAppState.SUBMITTED, RMAppState.FINAL_SAVING, RMAppEventType.KILL, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition(RMAppState.ACCEPTED, RMAppState.ACCEPTED, RMAppEventType.NODE_UPDATE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppNodeUpdateTransition()).addTransition(RMAppState.ACCEPTED, RMAppState.ACCEPTED, RMAppEventType.MOVE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppMoveTransition()).addTransition(RMAppState.ACCEPTED, RMAppState.RUNNING, RMAppEventType.ATTEMPT_REGISTERED).addTransition(RMAppState.ACCEPTED, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), RMAppEventType.ATTEMPT_FAILED, new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING, RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(FINISHED_TRANSITION, RMAppState.FINISHED)).addTransition(RMAppState.ACCEPTED, RMAppState.KILLING, RMAppEventType.KILL, (SingleArcTransition<RMAppImpl, RMAppEvent>)new KillAttemptTransition()).addTransition(RMAppState.ACCEPTED, RMAppState.ACCEPTED, RMAppEventType.APP_ACCEPTED).addTransition(RMAppState.RUNNING, RMAppState.RUNNING, RMAppEventType.NODE_UPDATE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppNodeUpdateTransition()).addTransition(RMAppState.RUNNING, RMAppState.RUNNING, RMAppEventType.MOVE, (SingleArcTransition<RMAppImpl, RMAppEvent>)new RMAppMoveTransition()).addTransition(RMAppState.RUNNING, RMAppState.FINAL_SAVING, RMAppEventType.ATTEMPT_UNREGISTERED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AttemptUnregisteredTransition(), RMAppState.FINISHING, RMAppState.FINISHED)).addTransition(RMAppState.RUNNING, RMAppState.FINISHED, RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition<RMAppImpl, RMAppEvent>)FINISHED_TRANSITION).addTransition(RMAppState.RUNNING, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), RMAppEventType.ATTEMPT_FAILED, new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition(RMAppState.RUNNING, RMAppState.KILLING, RMAppEventType.KILL, (SingleArcTransition<RMAppImpl, RMAppEvent>)new KillAttemptTransition()).addTransition(RMAppState.FINAL_SAVING, EnumSet.of(RMAppState.FINISHING, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINISHED), RMAppEventType.APP_UPDATE_SAVED, new FinalStateSavedTransition()).addTransition(RMAppState.FINAL_SAVING, RMAppState.FINAL_SAVING, RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new AttemptFinishedAtFinalSavingTransition()).addTransition(RMAppState.FINAL_SAVING, RMAppState.FINAL_SAVING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL, RMAppEventType.APP_NEW_SAVED)).addTransition(RMAppState.FINISHING, RMAppState.FINISHED, RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition<RMAppImpl, RMAppEvent>)FINISHED_TRANSITION).addTransition(RMAppState.FINISHING, RMAppState.FINISHING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL)).addTransition(RMAppState.KILLING, RMAppState.FINAL_SAVING, RMAppEventType.ATTEMPT_KILLED, (SingleArcTransition<RMAppImpl, RMAppEvent>)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition(RMAppState.KILLING, RMAppState.KILLING, EnumSet.of(RMAppEventType.NODE_UPDATE, new RMAppEventType[]{RMAppEventType.ATTEMPT_REGISTERED, RMAppEventType.ATTEMPT_UNREGISTERED, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.APP_UPDATE_SAVED, RMAppEventType.KILL})).addTransition(RMAppState.FINISHED, RMAppState.FINISHED, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.ATTEMPT_UNREGISTERED, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.KILL)).addTransition(RMAppState.FAILED, RMAppState.FAILED, EnumSet.of(RMAppEventType.KILL, RMAppEventType.NODE_UPDATE)).addTransition(RMAppState.KILLED, RMAppState.KILLED, EnumSet.of(RMAppEventType.APP_ACCEPTED, new RMAppEventType[]{RMAppEventType.APP_REJECTED, RMAppEventType.KILL, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.NODE_UPDATE})).installTopology();
    private final StateMachine<RMAppState, RMAppEventType, RMAppEvent> stateMachine;
    private static final ApplicationResourceUsageReport DUMMY_APPLICATION_RESOURCE_USAGE_REPORT = BuilderUtils.newApplicationResourceUsageReport(-1, -1, Resources.createResource(-1, -1), Resources.createResource(-1, -1), Resources.createResource(-1, -1));
    private static final int DUMMY_APPLICATION_ATTEMPT_NUMBER = -1;

    public RMAppImpl(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags) {
        this.applicationId = applicationId;
        this.name = name;
        this.rmContext = rmContext;
        this.dispatcher = rmContext.getDispatcher();
        this.handler = this.dispatcher.getEventHandler();
        this.conf = config;
        this.user = user;
        this.queue = queue;
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.submitTime = submitTime;
        this.startTime = System.currentTimeMillis();
        this.applicationType = applicationType;
        this.applicationTags = applicationTags;
        int globalMaxAppAttempts = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        int individualMaxAppAttempts = submissionContext.getMaxAppAttempts();
        if (individualMaxAppAttempts <= 0 || individualMaxAppAttempts > globalMaxAppAttempts) {
            this.maxAppAttempts = globalMaxAppAttempts;
            LOG.warn((Object)("The specific max attempts: " + individualMaxAppAttempts + " for application: " + applicationId.getId() + " is invalid, because it is out of the range [1, " + globalMaxAppAttempts + "]. Use the global max attempts instead."));
        } else {
            this.maxAppAttempts = individualMaxAppAttempts;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make(this);
        rmContext.getRMApplicationHistoryWriter().applicationStarted(this);
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null && this.currentAttempt.getFinalApplicationStatus() != null) {
                FinalApplicationStatus finalApplicationStatus = this.currentAttempt.getFinalApplicationStatus();
                return finalApplicationStatus;
            }
            FinalApplicationStatus finalApplicationStatus = this.createFinalApplicationStatus(this.stateMachine.getCurrentState());
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppState getState() {
        this.readLock.lock();
        try {
            RMAppState rMAppState = this.stateMachine.getCurrentState();
            return rMAppState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                float f = this.currentAttempt.getProgress();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.attempts.get(appAttemptId);
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getCurrentAppAttempt() {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.currentAttempt;
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
        this.readLock.lock();
        try {
            Map<ApplicationAttemptId, RMAppAttempt> map = Collections.unmodifiableMap(this.attempts);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private FinalApplicationStatus createFinalApplicationStatus(RMAppState state) {
        switch (state) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: 
            case RUNNING: 
            case FINAL_SAVING: 
            case KILLING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case FINISHING: 
            case FINISHED: 
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
        this.writeLock.lock();
        try {
            int updatedNodeCount = this.updatedNodes.size();
            updatedNodes.addAll(this.updatedNodes);
            this.updatedNodes.clear();
            int n = updatedNodeCount;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
        this.readLock.lock();
        try {
            ApplicationAttemptId currentApplicationAttemptId = null;
            org.apache.hadoop.yarn.api.records.Token clientToAMToken = null;
            String trackingUrl = UNAVAILABLE;
            String host = UNAVAILABLE;
            String origTrackingUrl = UNAVAILABLE;
            int rpcPort = -1;
            ApplicationResourceUsageReport appUsageReport = DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            FinalApplicationStatus finishState = this.getFinalApplicationStatus();
            String diags = UNAVAILABLE;
            float progress = 0.0f;
            org.apache.hadoop.yarn.api.records.Token amrmToken = null;
            if (allowAccess) {
                Token<AMRMTokenIdentifier> token;
                if (this.currentAttempt != null) {
                    Token<ClientToAMTokenIdentifier> attemptClientToAMToken;
                    currentApplicationAttemptId = this.currentAttempt.getAppAttemptId();
                    trackingUrl = this.currentAttempt.getTrackingUrl();
                    origTrackingUrl = this.currentAttempt.getOriginalTrackingUrl();
                    if (UserGroupInformation.isSecurityEnabled() && (attemptClientToAMToken = this.currentAttempt.createClientToken(clientUserName)) != null) {
                        clientToAMToken = BuilderUtils.newClientToAMToken(attemptClientToAMToken.getIdentifier(), attemptClientToAMToken.getKind().toString(), attemptClientToAMToken.getPassword(), attemptClientToAMToken.getService().toString());
                    }
                    host = this.currentAttempt.getHost();
                    rpcPort = this.currentAttempt.getRpcPort();
                    appUsageReport = this.currentAttempt.getApplicationResourceUsageReport();
                    progress = this.currentAttempt.getProgress();
                }
                diags = this.diagnostics.toString();
                if (this.currentAttempt != null && this.currentAttempt.getAppAttemptState() == RMAppAttemptState.LAUNCHED && this.getApplicationSubmissionContext().getUnmanagedAM() && clientUserName != null && this.getUser().equals(clientUserName) && (token = this.currentAttempt.getAMRMToken()) != null) {
                    amrmToken = BuilderUtils.newAMRMToken(token.getIdentifier(), token.getKind().toString(), token.getPassword(), token.getService().toString());
                }
            }
            if (currentApplicationAttemptId == null) {
                currentApplicationAttemptId = BuilderUtils.newApplicationAttemptId(this.applicationId, -1);
            }
            ApplicationReport applicationReport = BuilderUtils.newApplicationReport(this.applicationId, currentApplicationAttemptId, this.user, this.queue, this.name, host, rpcPort, clientToAMToken, this.createApplicationState(), diags, trackingUrl, this.startTime, this.finishTime, finishState, appUsageReport, origTrackingUrl, progress, this.applicationType, amrmToken, this.applicationTags);
            return applicationReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                String string = this.currentAttempt.getTrackingUrl();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getDiagnostics() {
        this.readLock.lock();
        try {
            StringBuilder stringBuilder = this.diagnostics;
            return stringBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RMAppEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId appID = event.getApplicationId();
            LOG.debug((Object)("Processing event for " + appID + " of type " + event.getType()));
            RMAppState oldState = this.getState();
            try {
                this.stateMachine.doTransition((RMAppEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(appID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore.ApplicationState appState = state.getApplicationState().get(this.getApplicationId());
        this.recoveredFinalState = appState.getState();
        LOG.info((Object)("Recovering app: " + this.getApplicationId() + " with " + appState.getAttemptCount() + " attempts and final state = " + (Object)((Object)this.recoveredFinalState)));
        this.diagnostics.append(appState.getDiagnostics());
        this.storedFinishTime = appState.getFinishTime();
        this.startTime = appState.getStartTime();
        for (int i = 0; i < appState.getAttemptCount(); ++i) {
            this.createNewAttempt();
            ((RMAppAttemptImpl)this.currentAttempt).recover(state);
        }
    }

    private void createNewAttempt() {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance(this.applicationId, this.attempts.size() + 1);
        RMAppAttemptImpl attempt = new RMAppAttemptImpl(appAttemptId, this.rmContext, this.scheduler, this.masterService, this.submissionContext, this.conf, this.maxAppAttempts == this.attempts.size());
        this.attempts.put(appAttemptId, attempt);
        this.currentAttempt = attempt;
    }

    private void createAndStartNewAttempt(boolean transferStateFromPreviousAttempt) {
        this.createNewAttempt();
        this.handler.handle(new RMAppStartAttemptEvent(this.currentAttempt.getAppAttemptId(), transferStateFromPreviousAttempt));
    }

    private void processNodeUpdate(RMAppNodeUpdateEvent.RMAppNodeUpdateType type, RMNode node) {
        NodeState nodeState = node.getState();
        this.updatedNodes.add(node);
        LOG.debug((Object)("Received node update event:" + (Object)((Object)type) + " for node:" + node + " with state:" + (Object)((Object)nodeState)));
    }

    private String getAppAttemptFailedDiagnostics(RMAppEvent event) {
        String msg = null;
        RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
        if (this.submissionContext.getUnmanagedAM()) {
            msg = "Unmanaged application " + this.getApplicationId() + " failed due to " + failedEvent.getDiagnostics() + ". Failing the application.";
        } else if (this.attempts.size() >= this.maxAppAttempts) {
            msg = "Application " + this.getApplicationId() + " failed " + this.maxAppAttempts + " times due to " + failedEvent.getDiagnostics() + ". Failing the application.";
        }
        return msg;
    }

    private void rememberTargetTransitions(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState, RMAppState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        this.stateBeforeFinalSaving = this.getState();
        this.storedFinishTime = System.currentTimeMillis();
        LOG.info((Object)("Updating application " + this.applicationId + " with final state: " + (Object)((Object)this.targetedFinalState)));
        String diags = null;
        switch ((RMAppEventType)((Object)event.getType())) {
            case APP_REJECTED: {
                RMAppRejectedEvent rejectedEvent = (RMAppRejectedEvent)event;
                diags = rejectedEvent.getMessage();
                break;
            }
            case ATTEMPT_FINISHED: {
                RMAppFinishedAttemptEvent finishedEvent = (RMAppFinishedAttemptEvent)event;
                diags = finishedEvent.getDiagnostics();
                break;
            }
            case ATTEMPT_FAILED: {
                RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
                diags = this.getAppAttemptFailedDiagnostics(failedEvent);
                break;
            }
            case ATTEMPT_KILLED: {
                diags = RMAppImpl.getAppKilledDiagnostics();
                break;
            }
        }
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(this.submitTime, this.startTime, this.submissionContext, this.user, stateToBeStored, diags, this.storedFinishTime);
        this.rmContext.getStateStore().updateApplicationState(appState);
    }

    private static String getAppKilledDiagnostics() {
        return "Application killed by user.";
    }

    @Override
    public String getApplicationType() {
        return this.applicationType;
    }

    @Override
    public Set<String> getApplicationTags() {
        return this.applicationTags;
    }

    @Override
    public boolean isAppFinalStateStored() {
        RMAppState state = this.getState();
        return state.equals((Object)RMAppState.FINISHING) || state.equals((Object)RMAppState.FINISHED) || state.equals((Object)RMAppState.FAILED) || state.equals((Object)RMAppState.KILLED);
    }

    @Override
    public YarnApplicationState createApplicationState() {
        RMAppState rmAppState = this.getState();
        if (rmAppState.equals((Object)RMAppState.FINAL_SAVING)) {
            rmAppState = this.stateBeforeFinalSaving;
        }
        if (rmAppState.equals((Object)RMAppState.KILLING)) {
            rmAppState = this.stateBeforeKilling;
        }
        return RMServerUtils.createApplicationState(rmAppState);
    }

    public static boolean isAppInFinalState(RMApp rmApp) {
        RMAppState appState = ((RMAppImpl)rmApp).getRecoveredFinalState();
        return appState == RMAppState.FAILED || appState == RMAppState.FINISHED || appState == RMAppState.KILLED;
    }

    private RMAppState getRecoveredFinalState() {
        return this.recoveredFinalState;
    }

    private static final class AttemptFailedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private final RMAppState initialState;

        public AttemptFailedTransition(RMAppState initialState) {
            this.initialState = initialState;
        }

        @Override
        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            if (!app.submissionContext.getUnmanagedAM() && app.attempts.size() < app.maxAppAttempts) {
                boolean transferStateFromPreviousAttempt = false;
                RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
                transferStateFromPreviousAttempt = failedEvent.getTransferStateFromPreviousAttempt();
                RMAppAttempt oldAttempt = app.currentAttempt;
                app.createAndStartNewAttempt(transferStateFromPreviousAttempt);
                if (transferStateFromPreviousAttempt) {
                    ((RMAppAttemptImpl)app.currentAttempt).transferStateFromPreviousAttempt(oldAttempt);
                }
                return this.initialState;
            }
            app.rememberTargetTransitionsAndStoreState(event, new AttemptFailedFinalStateSavedTransition(), RMAppState.FAILED, RMAppState.FAILED);
            return RMAppState.FINAL_SAVING;
        }
    }

    private static class FinalTransition
    extends RMAppTransition {
        private final RMAppState finalState;

        public FinalTransition(RMAppState finalState) {
            this.finalState = finalState;
        }

        private Set<NodeId> getNodesOnWhichAttemptRan(RMAppImpl app) {
            HashSet<NodeId> nodes = new HashSet<NodeId>();
            for (RMAppAttempt attempt : app.attempts.values()) {
                nodes.addAll(attempt.getRanNodes());
            }
            return nodes;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            Set<NodeId> nodes = this.getNodesOnWhichAttemptRan(app);
            for (NodeId nodeId : nodes) {
                app.handler.handle(new RMNodeCleanAppEvent(nodeId, app.applicationId));
            }
            app.finishTime = app.storedFinishTime;
            if (app.finishTime == 0L) {
                app.finishTime = System.currentTimeMillis();
            }
            app.handler.handle(new AppRemovedSchedulerEvent(app.applicationId, this.finalState));
            app.handler.handle(new RMAppManagerEvent(app.applicationId, RMAppManagerEventType.APP_COMPLETED));
            app.rmContext.getRMApplicationHistoryWriter().applicationFinished(app, this.finalState);
        }
    }

    private static final class AppRejectedTransition
    extends FinalTransition {
        public AppRejectedTransition() {
            super(RMAppState.FAILED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppRejectedEvent rejectedEvent = (RMAppRejectedEvent)event;
            app.diagnostics.append(rejectedEvent.getMessage());
            super.transition(app, event);
        }
    }

    private static class KillAttemptTransition
    extends RMAppTransition {
        private KillAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.stateBeforeKilling = app.getState();
            app.handler.handle(new RMAppAttemptEvent(app.currentAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        }
    }

    private static class AppKilledTransition
    extends FinalTransition {
        public AppKilledTransition() {
            super(RMAppState.KILLED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append(RMAppImpl.getAppKilledDiagnostics());
            super.transition(app, event);
        }
    }

    private static class AppFinishedFinalStateSavedTransition
    extends RMAppTransition {
        RMAppEvent attemptUnregistered;

        public AppFinishedFinalStateSavedTransition(RMAppEvent attemptUnregistered) {
            this.attemptUnregistered = attemptUnregistered;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            new AttemptUnregisteredTransition().transition(app, this.attemptUnregistered);
            FINISHED_TRANSITION.transition(app, event);
        }
    }

    private static class AttemptFinishedAtFinalSavingTransition
    extends RMAppTransition {
        private AttemptFinishedAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (app.targetedFinalState.equals((Object)RMAppState.FAILED) || app.targetedFinalState.equals((Object)RMAppState.KILLED)) {
                return;
            }
            app.rememberTargetTransitions(event, new AppFinishedFinalStateSavedTransition(app.eventCausingFinalSaving), RMAppState.FINISHED);
        }
    }

    private static class AppFinishedTransition
    extends FinalTransition {
        public AppFinishedTransition() {
            super(RMAppState.FINISHED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppFinishedAttemptEvent finishedEvent = (RMAppFinishedAttemptEvent)event;
            app.diagnostics.append(finishedEvent.getDiagnostics());
            super.transition(app, event);
        }
    }

    private static class AttemptUnregisteredTransition
    extends RMAppTransition {
        private AttemptUnregisteredTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.finishTime = app.storedFinishTime;
        }
    }

    private static final class FinalSavingTransition
    extends RMAppTransition {
        Object transitionToDo;
        RMAppState targetedFinalState;
        RMAppState stateToBeStored;

        public FinalSavingTransition(Object transitionToDo, RMAppState targetedFinalState) {
            this(transitionToDo, targetedFinalState, targetedFinalState);
        }

        public FinalSavingTransition(Object transitionToDo, RMAppState targetedFinalState, RMAppState stateToBeStored) {
            this.transitionToDo = transitionToDo;
            this.targetedFinalState = targetedFinalState;
            this.stateToBeStored = stateToBeStored;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.rememberTargetTransitionsAndStoreState(event, this.transitionToDo, this.targetedFinalState, this.stateToBeStored);
        }
    }

    private static final class RMAppNewlySavingTransition
    extends RMAppTransition {
        private RMAppNewlySavingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            LOG.info((Object)("Storing application with id " + app.applicationId));
            app.rmContext.getStateStore().storeNewApplication(app);
        }
    }

    private static class AttemptFailedFinalStateSavedTransition
    extends RMAppTransition {
        private AttemptFailedFinalStateSavedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            String msg = null;
            if (event instanceof RMAppFailedAttemptEvent) {
                msg = app.getAppAttemptFailedDiagnostics(event);
            }
            LOG.info(msg);
            app.diagnostics.append(msg);
            new FinalTransition(RMAppState.FAILED).transition(app, event);
        }
    }

    private static final class FinalStateSavedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private FinalStateSavedTransition() {
        }

        @Override
        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            RMAppUpdateSavedEvent storeEvent = (RMAppUpdateSavedEvent)event;
            if (storeEvent.getUpdatedException() != null) {
                LOG.error((Object)("Failed to update the final state of application" + storeEvent.getApplicationId()), (Throwable)storeEvent.getUpdatedException());
                ExitUtil.terminate(1, storeEvent.getUpdatedException());
            }
            if (app.transitionTodo instanceof SingleArcTransition) {
                ((SingleArcTransition)app.transitionTodo).transition(app, app.eventCausingFinalSaving);
            } else if (app.transitionTodo instanceof MultipleArcTransition) {
                ((MultipleArcTransition)app.transitionTodo).transition(app, app.eventCausingFinalSaving);
            }
            return app.targetedFinalState;
        }
    }

    private static final class StartAppAttemptTransition
    extends RMAppTransition {
        private StartAppAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.createAndStartNewAttempt(false);
        }
    }

    private static final class AddApplicationToSchedulerTransition
    extends RMAppTransition {
        private AddApplicationToSchedulerTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (event instanceof RMAppNewSavedEvent) {
                RMAppNewSavedEvent storeEvent = (RMAppNewSavedEvent)event;
                if (((RMAppNewSavedEvent)event).getStoredException() != null) {
                    LOG.error((Object)("Failed to store application: " + storeEvent.getApplicationId()), (Throwable)storeEvent.getStoredException());
                    ExitUtil.terminate(1, storeEvent.getStoredException());
                }
            }
            app.handler.handle(new AppAddedSchedulerEvent(app.applicationId, app.submissionContext.getQueue(), app.user));
        }
    }

    private static final class RMAppRecoveredTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private RMAppRecoveredTransition() {
        }

        @Override
        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            for (RMAppAttempt attempt : app.getAppAttempts().values()) {
                attempt.handle(new RMAppAttemptEvent(attempt.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
            }
            if (app.recoveredFinalState != null) {
                new FinalTransition(app.recoveredFinalState).transition(app, event);
                return app.recoveredFinalState;
            }
            if (app.currentAttempt != null && (app.currentAttempt.getState() == RMAppAttemptState.KILLED || app.currentAttempt.getState() == RMAppAttemptState.FINISHED || app.currentAttempt.getState() == RMAppAttemptState.FAILED && app.attempts.size() == app.maxAppAttempts)) {
                return RMAppState.ACCEPTED;
            }
            new AddApplicationToSchedulerTransition().transition(app, event);
            if (app.attempts.isEmpty()) {
                return RMAppState.SUBMITTED;
            }
            return RMAppState.ACCEPTED;
        }
    }

    private static final class RMAppMoveTransition
    extends RMAppTransition {
        private RMAppMoveTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppMoveEvent moveEvent = (RMAppMoveEvent)event;
            try {
                app.queue = app.scheduler.moveApplication(app.applicationId, moveEvent.getTargetQueue());
            }
            catch (YarnException ex) {
                moveEvent.getResult().setException(ex);
                return;
            }
            moveEvent.getResult().set(null);
        }
    }

    private static final class RMAppNodeUpdateTransition
    extends RMAppTransition {
        private RMAppNodeUpdateTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppNodeUpdateEvent nodeUpdateEvent = (RMAppNodeUpdateEvent)event;
            app.processNodeUpdate(nodeUpdateEvent.getUpdateType(), nodeUpdateEvent.getNode());
        }
    }

    private static class RMAppTransition
    implements SingleArcTransition<RMAppImpl, RMAppEvent> {
        private RMAppTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
        }
    }
}

