/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;
import org.apache.hadoop.yarn.util.SystemClock;

public class AMLivelinessMonitor
extends AbstractLivelinessMonitor<ApplicationAttemptId> {
    private EventHandler dispatcher;

    public AMLivelinessMonitor(Dispatcher d) {
        super("AMLivelinessMonitor", new SystemClock());
        this.dispatcher = d.getEventHandler();
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        int expireIntvl = conf.getInt("yarn.am.liveness-monitor.expiry-interval-ms", 600000);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(expireIntvl / 3);
    }

    @Override
    protected void expire(ApplicationAttemptId id) {
        this.dispatcher.handle(new RMAppAttemptEvent(id, RMAppAttemptEventType.EXPIRE));
    }
}

