/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAllocatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMContainerImpl
implements RMContainer {
    private static final Log LOG = LogFactory.getLog(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent>(RMContainerState.NEW).addTransition(RMContainerState.NEW, RMContainerState.ALLOCATED, RMContainerEventType.START, new ContainerStartedTransition()).addTransition(RMContainerState.NEW, RMContainerState.KILLED, RMContainerEventType.KILL).addTransition(RMContainerState.NEW, RMContainerState.RESERVED, RMContainerEventType.RESERVED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new ContainerReservedTransition()).addTransition(RMContainerState.RESERVED, RMContainerState.RESERVED, RMContainerEventType.RESERVED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new ContainerReservedTransition()).addTransition(RMContainerState.RESERVED, RMContainerState.ALLOCATED, RMContainerEventType.START, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new ContainerStartedTransition()).addTransition(RMContainerState.RESERVED, RMContainerState.KILLED, RMContainerEventType.KILL).addTransition(RMContainerState.RESERVED, RMContainerState.RELEASED, RMContainerEventType.RELEASED).addTransition(RMContainerState.ALLOCATED, RMContainerState.ACQUIRED, RMContainerEventType.ACQUIRED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new AcquiredTransition()).addTransition(RMContainerState.ALLOCATED, RMContainerState.EXPIRED, RMContainerEventType.EXPIRE, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new FinishedTransition()).addTransition(RMContainerState.ALLOCATED, RMContainerState.KILLED, RMContainerEventType.KILL, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new FinishedTransition()).addTransition(RMContainerState.ACQUIRED, RMContainerState.RUNNING, RMContainerEventType.LAUNCHED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new LaunchedTransition()).addTransition(RMContainerState.ACQUIRED, RMContainerState.COMPLETED, RMContainerEventType.FINISHED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new ContainerFinishedAtAcquiredState()).addTransition(RMContainerState.ACQUIRED, RMContainerState.RELEASED, RMContainerEventType.RELEASED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new KillTransition()).addTransition(RMContainerState.ACQUIRED, RMContainerState.EXPIRED, RMContainerEventType.EXPIRE, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new KillTransition()).addTransition(RMContainerState.ACQUIRED, RMContainerState.KILLED, RMContainerEventType.KILL, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new KillTransition()).addTransition(RMContainerState.RUNNING, RMContainerState.COMPLETED, RMContainerEventType.FINISHED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new FinishedTransition()).addTransition(RMContainerState.RUNNING, RMContainerState.KILLED, RMContainerEventType.KILL, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new KillTransition()).addTransition(RMContainerState.RUNNING, RMContainerState.RELEASED, RMContainerEventType.RELEASED, (SingleArcTransition<RMContainerImpl, RMContainerEvent>)new KillTransition()).addTransition(RMContainerState.RUNNING, RMContainerState.RUNNING, RMContainerEventType.EXPIRE).addTransition(RMContainerState.COMPLETED, RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition(RMContainerState.EXPIRED, RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition(RMContainerState.RELEASED, RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition(RMContainerState.KILLED, RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make(this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final Container container;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private final String user;
    private Resource reservedResource;
    private NodeId reservedNode;
    private Priority reservedPriority;
    private long startTime;
    private long finishTime;
    private ContainerStatus finishedStatus;

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext) {
        this.containerId = container.getId();
        this.nodeId = nodeId;
        this.container = container;
        this.appAttemptId = appAttemptId;
        this.user = user;
        this.startTime = System.currentTimeMillis();
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.containerAllocationExpirer = rmContext.getContainerAllocationExpirer();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        rmContext.getRMApplicationHistoryWriter().containerStarted(this);
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getReservedResource() {
        return this.reservedResource;
    }

    @Override
    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    @Override
    public Priority getReservedPriority() {
        return this.reservedPriority;
    }

    @Override
    public Resource getAllocatedResource() {
        return this.container.getResource();
    }

    @Override
    public NodeId getAllocatedNode() {
        return this.container.getNodeId();
    }

    @Override
    public Priority getAllocatedPriority() {
        return this.container.getPriority();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        try {
            this.readLock.lock();
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnosticsInfo() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                String string = this.getFinishedStatus().getDiagnostics();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLogURL() {
        try {
            this.readLock.lock();
            String string = WebAppUtils.getRunningLogURL("//" + this.container.getNodeHttpAddress(), ConverterUtils.toString(this.containerId), this.user);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getContainerExitStatus() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                int n = this.getFinishedStatus().getExitStatus();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerState getContainerState() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                ContainerState containerState = this.getFinishedStatus().getState();
                return containerState;
            }
            ContainerState containerState = ContainerState.RUNNING;
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return this.containerId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RMContainerEvent event) {
        LOG.debug((Object)("Processing " + event.getContainerId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition((RMContainerEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on container " + this.containerId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(event.getContainerId() + " Container Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ContainerStatus getFinishedStatus() {
        return this.finishedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerReport createContainerReport() {
        this.readLock.lock();
        ContainerReport containerReport = null;
        try {
            containerReport = ContainerReport.newInstance(this.getContainerId(), this.getAllocatedResource(), this.getAllocatedNode(), this.getAllocatedPriority(), this.getStartTime(), this.getFinishTime(), this.getDiagnosticsInfo(), this.getLogURL(), this.getContainerExitStatus(), this.getContainerState());
        }
        finally {
            this.readLock.unlock();
        }
        return containerReport;
    }

    private static final class KillTransition
    extends FinishedTransition {
        private KillTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            container.eventHandler.handle(new RMNodeCleanContainerEvent(container.nodeId, container.containerId));
            super.transition(container, event);
        }
    }

    private static final class ContainerFinishedAtAcquiredState
    extends FinishedTransition {
        private ContainerFinishedAtAcquiredState() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            super.transition(container, event);
        }
    }

    private static class FinishedTransition
    extends BaseTransition {
        private FinishedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerFinishedEvent finishedEvent = (RMContainerFinishedEvent)event;
            container.finishTime = System.currentTimeMillis();
            container.finishedStatus = finishedEvent.getRemoteContainerStatus();
            container.eventHandler.handle(new RMAppAttemptContainerFinishedEvent(container.appAttemptId, finishedEvent.getRemoteContainerStatus()));
            container.rmContext.getRMApplicationHistoryWriter().containerFinished(container);
        }
    }

    private static final class LaunchedTransition
    extends BaseTransition {
        private LaunchedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
        }
    }

    private static final class AcquiredTransition
    extends BaseTransition {
        private AcquiredTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.register(container.getContainerId());
            container.eventHandler.handle(new RMAppAttemptContainerAcquiredEvent(container.getApplicationAttemptId(), container.getContainer()));
        }
    }

    private static final class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.eventHandler.handle(new RMAppAttemptContainerAllocatedEvent(container.appAttemptId));
        }
    }

    private static final class ContainerReservedTransition
    extends BaseTransition {
        private ContainerReservedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerReservedEvent e = (RMContainerReservedEvent)event;
            container.reservedResource = e.getReservedResource();
            container.reservedNode = e.getReservedNode();
            container.reservedPriority = e.getReservedPriority();
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMContainerImpl, RMContainerEvent> {
        private BaseTransition() {
        }

        @Override
        public void transition(RMContainerImpl cont, RMContainerEvent event) {
        }
    }
}

