/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(ParentQueue.class);
    private CSQueue parent;
    private final String queueName;
    private float capacity;
    private float maximumCapacity;
    private float absoluteCapacity;
    private float absoluteMaxCapacity;
    private float absoluteUsedCapacity = 0.0f;
    private float usedCapacity = 0.0f;
    private final Set<CSQueue> childQueues;
    private final Comparator<CSQueue> queueComparator;
    private Resource usedResources = Resources.createResource(0, 0);
    private final boolean rootQueue;
    private final Resource minimumAllocation;
    private volatile int numApplications;
    private volatile int numContainers;
    private QueueState state;
    private final QueueMetrics metrics;
    private QueueInfo queueInfo;
    private Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ResourceCalculator resourceCalculator;
    private static float PRECISION = 5.0E-4f;

    public ParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) {
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.parent = parent;
        this.queueName = queueName;
        this.rootQueue = parent == null;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        float rawCapacity = cs.getConfiguration().getCapacity(this.getQueuePath());
        if (this.rootQueue && rawCapacity != 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100.0f);
        }
        float capacity = rawCapacity / 100.0f;
        float parentAbsoluteCapacity = this.rootQueue ? 1.0f : parent.getAbsoluteCapacity();
        float absoluteCapacity = parentAbsoluteCapacity * capacity;
        float maximumCapacity = cs.getConfiguration().getMaximumCapacity(this.getQueuePath()) / 100.0f;
        float absoluteMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, parent);
        QueueState state = cs.getConfiguration().getState(this.getQueuePath());
        Map<QueueACL, AccessControlList> acls = cs.getConfiguration().getAcls(this.getQueuePath());
        this.queueInfo = this.recordFactory.newRecordInstance(QueueInfo.class);
        this.queueInfo.setQueueName(queueName);
        this.queueInfo.setChildQueues(new ArrayList<QueueInfo>());
        this.setupQueueConfigs(cs.getClusterResources(), capacity, absoluteCapacity, maximumCapacity, absoluteMaxCapacity, state, acls);
        this.queueComparator = cs.getQueueComparator();
        this.childQueues = new TreeSet<CSQueue>(this.queueComparator);
        LOG.info((Object)("Initialized parent-queue " + queueName + " name=" + queueName + ", fullname=" + this.getQueuePath()));
    }

    private synchronized void setupQueueConfigs(Resource clusterResource, float capacity, float absoluteCapacity, float maximumCapacity, float absoluteMaxCapacity, QueueState state, Map<QueueACL, AccessControlList> acls) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), capacity, maximumCapacity);
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), absoluteCapacity, absoluteMaxCapacity);
        this.capacity = capacity;
        this.absoluteCapacity = absoluteCapacity;
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.state = state;
        this.acls = acls;
        this.queueInfo.setCapacity(this.capacity);
        this.queueInfo.setMaximumCapacity(this.maximumCapacity);
        this.queueInfo.setQueueState(this.state);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            aclsString.append((Object)((Object)e.getKey()) + ":" + e.getValue().getAclString());
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        LOG.info((Object)(this.queueName + ", capacity=" + capacity + ", asboluteCapacity=" + absoluteCapacity + ", maxCapacity=" + maximumCapacity + ", asboluteMaxCapacity=" + absoluteMaxCapacity + ", state=" + (Object)((Object)state) + ", acls=" + aclsString));
    }

    void setChildQueues(Collection<CSQueue> childQueues) {
        float childCapacities = 0.0f;
        for (CSQueue queue : childQueues) {
            childCapacities += queue.getCapacity();
        }
        float delta = Math.abs(1.0f - childCapacities);
        if (this.capacity > 0.0f && delta > PRECISION || this.capacity == 0.0f && childCapacities > 0.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + childCapacities + " for children of queue " + this.queueName);
        }
        this.childQueues.clear();
        this.childQueues.addAll(childQueues);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
        }
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getQueuePath() {
        String parentPath = this.parent == null ? "" : this.parent.getQueuePath() + ".";
        return parentPath + this.getQueueName();
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.absoluteMaxCapacity;
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    @Override
    public float getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return null;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized Resource getUsedResources() {
        return this.usedResources;
    }

    @Override
    public synchronized List<CSQueue> getChildQueues() {
        return new ArrayList<CSQueue>(this.childQueues);
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.numApplications;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.queueInfo.setCurrentCapacity(this.usedCapacity);
        ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            for (CSQueue child : this.childQueues) {
                childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
            }
        }
        this.queueInfo.setChildQueues(childQueuesInfo);
        return this.queueInfo;
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (CSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    public String toString() {
        return this.queueName + ": " + "numChildQueue= " + this.childQueues.size() + ", " + "capacity=" + this.capacity + ", " + "absoluteCapacity=" + this.absoluteCapacity + ", " + "usedResources=" + this.usedResources + "usedCapacity=" + this.getUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof ParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        ParentQueue newlyParsedParentQueue = (ParentQueue)newlyParsedQueue;
        this.setupQueueConfigs(clusterResource, newlyParsedParentQueue.capacity, newlyParsedParentQueue.absoluteCapacity, newlyParsedParentQueue.maximumCapacity, newlyParsedParentQueue.absoluteMaxCapacity, newlyParsedParentQueue.state, newlyParsedParentQueue.acls);
        Map<String, CSQueue> currentChildQueues = this.getQueues(this.childQueues);
        Map<String, CSQueue> newChildQueues = this.getQueues(newlyParsedParentQueue.childQueues);
        for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
            String newChildQueueName = e.getKey();
            CSQueue newChildQueue = e.getValue();
            CSQueue childQueue = currentChildQueues.get(newChildQueueName);
            if (childQueue != null) {
                childQueue.reinitialize(newChildQueue, clusterResource);
                LOG.info((Object)(this.getQueueName() + ": re-configured queue: " + childQueue));
                continue;
            }
            newChildQueue.setParent(this);
            currentChildQueues.put(newChildQueueName, newChildQueue);
            LOG.info((Object)(this.getQueueName() + ": added new child queue: " + newChildQueue));
        }
        this.childQueues.clear();
        this.childQueues.addAll(currentChildQueues.values());
    }

    Map<String, CSQueue> getQueues(Set<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueueName(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (this.acls.get((Object)acl).isUserAllowed(user)) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasAccess(acl, user);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String user, String queue) throws AccessControlException {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (queue.equals(this.queueName)) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.queueName);
            }
            if (this.state != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId);
            }
            this.addApplication(applicationId, user);
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(applicationId, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(applicationId, user);
                throw ace;
            }
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
    }

    private synchronized void addApplication(ApplicationId applicationId, String user) {
        ++this.numApplications;
        LOG.info((Object)("Application added - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(ApplicationId application, String user) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.removeApplication(application, user);
        }
        if (this.parent != null) {
            this.parent.finishApplication(application, user);
        }
    }

    public synchronized void removeApplication(ApplicationId applicationId, String user) {
        --this.numApplications;
        LOG.info((Object)("Application removed - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.absoluteUsedCapacity = absUsedCapacity;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.capacity, maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), this.absoluteCapacity, absMaxCapacity);
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absMaxCapacity;
    }

    @Override
    public synchronized CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node) {
        CSAssignment assignment = new CSAssignment(Resources.createResource(0, 0), NodeType.NODE_LOCAL);
        while (this.canAssign(clusterResource, node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueueName()));
            }
            if (!this.assignToQueue(clusterResource)) break;
            CSAssignment assignedToChild = this.assignContainersToChildQueues(clusterResource, node);
            assignment.setType(assignedToChild.getType());
            if (!Resources.greaterThan(this.resourceCalculator, clusterResource, assignedToChild.getResource(), Resources.none())) break;
            this.allocateResource(clusterResource, assignedToChild.getResource());
            Resources.addTo(assignment.getResource(), assignedToChild.getResource());
            LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ParentQ=" + this.getQueueName() + " assignedSoFarInThisIteration=" + assignment.getResource() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity()));
            }
            if (this.rootQueue && assignment.getType() != NodeType.OFF_SWITCH) continue;
            if (!LOG.isDebugEnabled() || !this.rootQueue || assignment.getType() != NodeType.OFF_SWITCH) break;
            LOG.debug((Object)("Not assigning more than one off-switch container, assignments so far: " + assignment));
            break;
        }
        return assignment;
    }

    private synchronized boolean assignToQueue(Resource clusterResource) {
        float currentCapacity = Resources.divide(this.resourceCalculator, clusterResource, this.usedResources, clusterResource);
        if (currentCapacity >= this.absoluteMaxCapacity) {
            LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources + " current-capacity (" + currentCapacity + ") " + " >= max-capacity (" + this.absoluteMaxCapacity + ")"));
            return false;
        }
        return true;
    }

    private boolean canAssign(Resource clusterResource, FiCaSchedulerNode node) {
        return node.getReservedContainer() == null && Resources.greaterThanOrEqual(this.resourceCalculator, clusterResource, node.getAvailableResource(), this.minimumAllocation);
    }

    synchronized CSAssignment assignContainersToChildQueues(Resource cluster, FiCaSchedulerNode node) {
        CSAssignment assignment = new CSAssignment(Resources.createResource(0, 0), NodeType.NODE_LOCAL);
        this.printChildQueues();
        Iterator<CSQueue> iter = this.childQueues.iterator();
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            assignment = childQueue.assignContainers(cluster, node);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assigned to queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + assignment.getResource() + ", " + (Object)((Object)assignment.getType())));
            }
            if (!Resources.greaterThan(this.resourceCalculator, cluster, assignment.getResource(), Resources.none())) continue;
            iter.remove();
            LOG.info((Object)("Re-sorting assigned queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            this.childQueues.add(childQueue);
            if (!LOG.isDebugEnabled()) break;
            this.printChildQueues();
            break;
        }
        return assignment;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + "(" + q.getUsedCapacity() + "), ");
        }
        return sb.toString();
    }

    void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue completedChildQueue) {
        if (application != null) {
            ParentQueue parentQueue = this;
            synchronized (parentQueue) {
                this.releaseResource(clusterResource, rmContainer.getContainer().getResource());
                LOG.info((Object)("completedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            }
            Iterator<CSQueue> iter = this.childQueues.iterator();
            while (iter.hasNext()) {
                CSQueue csqueue = iter.next();
                if (!csqueue.equals(completedChildQueue)) continue;
                iter.remove();
                LOG.info((Object)("Re-sorting completed queue: " + csqueue.getQueuePath() + " stats: " + csqueue));
                this.childQueues.add(csqueue);
                break;
            }
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this);
            }
        }
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource) {
        Resources.addTo(this.usedResources, resource);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        ++this.numContainers;
    }

    synchronized void releaseResource(Resource clusterResource, Resource resource) {
        Resources.subtractFrom(this.usedResources, resource);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        --this.numContainers;
    }

    @Override
    public synchronized void updateClusterResource(Resource clusterResource) {
        for (CSQueue childQueue : this.childQueues) {
            childQueue.updateClusterResource(clusterResource);
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, FiCaSchedulerApp application, Container container) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.allocateResource(clusterResource, container.getResource());
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, application, container);
        }
    }

    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (CSQueue queue : this.childQueues) {
            queue.collectSchedulerApplications(apps);
        }
    }
}

