/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Collection;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

public class ComputeFairShares {
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    public static void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources, ResourceType type) {
        if (schedulables.isEmpty()) {
            return;
        }
        int totalMaxShare = 0;
        for (Schedulable schedulable : schedulables) {
            int maxShare = ComputeFairShares.getResourceValue(schedulable.getMaxShare(), type);
            if (maxShare == Integer.MAX_VALUE) {
                totalMaxShare = Integer.MAX_VALUE;
                break;
            }
            totalMaxShare += maxShare;
        }
        int totalResource = Math.min(totalMaxShare, ComputeFairShares.getResourceValue(totalResources, type));
        double rMax = 1.0;
        while (ComputeFairShares.resourceUsedWithWeightToResourceRatio(rMax, schedulables, type) < totalResource) {
            rMax *= 2.0;
        }
        double left = 0.0;
        double right = rMax;
        for (int i = 0; i < 25; ++i) {
            double mid = (left + right) / 2.0;
            if (ComputeFairShares.resourceUsedWithWeightToResourceRatio(mid, schedulables, type) < totalResource) {
                left = mid;
                continue;
            }
            right = mid;
        }
        for (Schedulable schedulable : schedulables) {
            ComputeFairShares.setResourceValue(ComputeFairShares.computeShare(schedulable, right, type), schedulable.getFairShare(), type);
        }
    }

    private static int resourceUsedWithWeightToResourceRatio(double w2rRatio, Collection<? extends Schedulable> schedulables, ResourceType type) {
        int resourcesTaken = 0;
        for (Schedulable schedulable : schedulables) {
            int share = ComputeFairShares.computeShare(schedulable, w2rRatio, type);
            resourcesTaken += share;
        }
        return resourcesTaken;
    }

    private static int computeShare(Schedulable sched, double w2rRatio, ResourceType type) {
        double share = (double)sched.getWeights().getWeight(type) * w2rRatio;
        share = Math.max(share, (double)ComputeFairShares.getResourceValue(sched.getMinShare(), type));
        share = Math.min(share, (double)ComputeFairShares.getResourceValue(sched.getMaxShare(), type));
        return (int)share;
    }

    private static int getResourceValue(Resource resource, ResourceType type) {
        switch (type) {
            case MEMORY: {
                return resource.getMemory();
            }
            case CPU: {
                return resource.getVirtualCores();
            }
        }
        throw new IllegalArgumentException("Invalid resource");
    }

    private static void setResourceValue(int val, Resource resource, ResourceType type) {
        switch (type) {
            case MEMORY: {
                resource.setMemory(val);
                break;
            }
            case CPU: {
                resource.setVirtualCores(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid resource");
            }
        }
    }
}

